// Boost.TypeErasure library
//
// Copyright 2012 Steven Watanabe
//
// Distributed under the Boost Software License Version 1.0. (See
// accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//
// $Id$

#ifndef BOOST_TYPE_ERASURE_DETAIL_CONST_HPP_INCLUDED
#define BOOST_TYPE_ERASURE_DETAIL_CONST_HPP_INCLUDED

#include <boost/mpl/if.hpp>
#include <boost/mpl/bool.hpp>
#include <boost/mpl/or.hpp>
#include <boost/mpl/and.hpp>
#include <boost/mpl/not.hpp>
#include <boost/type_traits/is_same.hpp>
#include <boost/type_traits/is_const.hpp>
#include <boost/type_traits/is_reference.hpp>
#include <boost/type_traits/remove_reference.hpp>
#include <boost/type_traits/remove_cv.hpp>
#include <boost/type_erasure/placeholder_of.hpp>
#include <boost/type_erasure/derived.hpp>

namespace foundryboost {} namespace boost = foundryboost; namespace foundryboost {
namespace type_erasure {
namespace detail {

template<class T>
struct is_non_const_ref : foundryboost::mpl::false_ {};
template<class T>
struct is_non_const_ref<T&> : foundryboost::mpl::true_ {};
template<class T>
struct is_non_const_ref<const T&> : foundryboost::mpl::false_ {};

template<class Placeholder, class Base>
struct should_be_const :
    ::foundryboost::mpl::or_<
        ::foundryboost::is_const<Placeholder>,
        ::foundryboost::type_erasure::detail::is_non_const_ref<
            typename ::foundryboost::type_erasure::placeholder_of<Base>::type
        >
    >
{};

template<class Placeholder, class Base>
struct should_be_non_const :
    ::foundryboost::mpl::and_<
        ::foundryboost::mpl::not_< ::foundryboost::is_const<Placeholder> >,
        ::foundryboost::mpl::not_<
            ::foundryboost::is_reference<
                typename ::foundryboost::type_erasure::placeholder_of<Base>::type
            >
        >
    >
{};

template<class Base>
struct non_const_this_param
{
    typedef typename ::foundryboost::type_erasure::placeholder_of<Base>::type placeholder;
    typedef typename ::foundryboost::type_erasure::derived<Base>::type plain_type;
    typedef typename ::foundryboost::mpl::if_<
        ::foundryboost::is_same<
            placeholder,
            typename ::foundryboost::remove_cv<
                typename ::foundryboost::remove_reference<placeholder>::type
            >::type&
        >,
        const plain_type,
        plain_type
    >::type type;
};

template<class T>
struct uncallable {};

template<class Placeholder, class Base>
struct maybe_const_this_param
{
    typedef typename ::foundryboost::type_erasure::derived<Base>::type plain_type;
    typedef typename ::foundryboost::remove_reference<Placeholder>::type plain_placeholder;
    typedef typename ::foundryboost::mpl::if_< ::foundryboost::is_reference<Placeholder>,
        typename ::foundryboost::mpl::if_<
            ::foundryboost::type_erasure::detail::should_be_non_const<plain_placeholder, Base>,
            plain_type&,
            typename ::foundryboost::mpl::if_<
                ::foundryboost::type_erasure::detail::should_be_const<plain_placeholder, Base>,
                const plain_type&,
                uncallable<plain_type>
            >::type
        >::type,
        plain_type
    >::type type;
};

#ifndef BOOST_NO_CXX11_RVALUE_REFERENCES

template<class Placeholder, class Base>
struct maybe_const_this_param<Placeholder&&, Base>
{
    typedef typename ::foundryboost::type_erasure::derived<Base>::type plain_type;
    typedef typename ::foundryboost::remove_reference<Placeholder>::type plain_placeholder;
    typedef typename ::foundryboost::type_erasure::placeholder_of<plain_type>::type self_placeholder;
    typedef typename ::foundryboost::mpl::if_< ::foundryboost::is_lvalue_reference<self_placeholder>,
        ::foundryboost::type_erasure::detail::uncallable<plain_type>,
        typename ::foundryboost::mpl::if_< ::foundryboost::is_rvalue_reference<self_placeholder>,
            const plain_type&,
            plain_type&&
        >::type
    >::type type;
};

#endif

}
}
}

#endif
