// Boost.TypeErasure library
//
// Copyright 2012 Steven Watanabe
//
// Distributed under the Boost Software License Version 1.0. (See
// accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//
// $Id$

#ifndef BOOST_TYPE_ERASURE_DETAIL_CHECK_MAP_HPP_INCLUDED
#define BOOST_TYPE_ERASURE_DETAIL_CHECK_MAP_HPP_INCLUDED

#include <boost/mpl/not.hpp>
#include <boost/mpl/or.hpp>
#include <boost/mpl/bool.hpp>
#include <boost/mpl/set.hpp>
#include <boost/mpl/has_key.hpp>
#include <boost/mpl/find_if.hpp>
#include <boost/mpl/fold.hpp>
#include <boost/mpl/end.hpp>
#include <boost/type_traits/is_same.hpp>
#include <boost/type_erasure/detail/get_placeholders.hpp>
#include <boost/type_erasure/detail/normalize.hpp>
#include <boost/type_erasure/deduced.hpp>
#include <boost/type_erasure/static_binding.hpp>

namespace foundryboost {} namespace boost = foundryboost; namespace foundryboost {
namespace type_erasure {
namespace detail {

template<class T>
struct is_deduced : foundryboost::mpl::false_ {};
template<class T>
struct is_deduced< ::foundryboost::type_erasure::deduced<T> > : foundryboost::mpl::true_ {};

// returns true if Map has a key for every non-deduced placeholder in Concept
template<class Concept, class Map>
struct check_map {
#ifndef BOOST_TYPE_ERASURE_USE_MP11
    typedef typename normalize_concept<Concept>::basic basic_components;

    typedef typename ::foundryboost::mpl::fold<
        basic_components,
        ::foundryboost::mpl::set0<>,
        ::foundryboost::type_erasure::detail::get_placeholders<
            ::foundryboost::mpl::_2,
            ::foundryboost::mpl::_1
        >
    >::type placeholders;

    // Every non-deduced placeholder referenced in this
    // map is indirectly deduced.
    typedef typename ::foundryboost::type_erasure::detail::get_placeholder_normalization_map<
        Concept>::type placeholder_subs;
    typedef typename ::foundryboost::mpl::fold<
        placeholder_subs,
        ::foundryboost::mpl::set0<>,
        ::foundryboost::mpl::insert<
            ::foundryboost::mpl::_1,
            ::foundryboost::mpl::second< ::foundryboost::mpl::_2>
        >
    >::type indirect_deduced_placeholders;
    typedef typename ::foundryboost::is_same<
        typename ::foundryboost::mpl::find_if<
            placeholders,
            ::foundryboost::mpl::not_<
                ::foundryboost::mpl::or_<
                    ::foundryboost::type_erasure::detail::is_deduced< ::foundryboost::mpl::_1>,
                    ::foundryboost::mpl::has_key<Map, ::foundryboost::mpl::_1>,
                    ::foundryboost::mpl::has_key<indirect_deduced_placeholders, ::foundryboost::mpl::_1>
                >
            >
        >::type,
        typename ::foundryboost::mpl::end<placeholders>::type
    >::type type;

#else
    typedef ::foundryboost::type_erasure::detail::get_all_placeholders<
        ::foundryboost::type_erasure::detail::normalize_concept_t<Concept>
    > placeholders;

    // Every non-deduced placeholder referenced in this
    // map is indirectly deduced.
    typedef typename ::foundryboost::type_erasure::detail::get_placeholder_normalization_map<
        Concept>::type placeholder_subs;
    typedef ::foundryboost::mp11::mp_unique<
        ::foundryboost::mp11::mp_append<
            ::foundryboost::mp11::mp_transform<
                ::foundryboost::mp11::mp_first,
                ::foundryboost::type_erasure::detail::make_mp_list<Map>
            >,
            ::foundryboost::mp11::mp_transform<
                ::foundryboost::mp11::mp_second,
                ::foundryboost::type_erasure::detail::make_mp_list<placeholder_subs>
            >
        >
    > okay_placeholders;
    template<class P>
    using check_placeholder = ::foundryboost::mpl::or_<
        ::foundryboost::type_erasure::detail::is_deduced<P>,
        ::foundryboost::mp11::mp_set_contains<okay_placeholders, P>
    >;
    typedef ::foundryboost::mp11::mp_all_of<placeholders, check_placeholder> type;
#endif
};

template<class Concept, class Map>
struct check_map<Concept, ::foundryboost::type_erasure::static_binding<Map> > :
    check_map<Concept, Map>
{};

}
}
}

#endif
