/*
 *
 * Copyright (c) 1998-2000
 * Dr John Maddock
 *
 * Use, modification and distribution are subject to the 
 * Boost Software License, Version 1.0. (See accompanying file 
 * LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
 *
 */
 
 /*
  *   LOCATION:    see http://www.boost.org/libs/regex for documentation.
  *   FILE         regex.h
  *   VERSION      3.12
  *   DESCRIPTION: Declares POSIX API functions
  */

#ifndef BOOST_RE_REGEX_H
#define BOOST_RE_REGEX_H

#include <boost/cregex.hpp>

/*
*  add using declarations to bring POSIX API functions into
* global scope, only if this is C++ (and not C).
*/
#ifdef __cplusplus

using foundryboost::regoff_t;
using foundryboost::regex_tA;
using foundryboost::regmatch_t;
using foundryboost::REG_BASIC;
using foundryboost::REG_EXTENDED;
using foundryboost::REG_ICASE;
using foundryboost::REG_NOSUB;
using foundryboost::REG_NEWLINE;
using foundryboost::REG_NOSPEC;
using foundryboost::REG_PEND;
using foundryboost::REG_DUMP;
using foundryboost::REG_NOCOLLATE;
using foundryboost::REG_ESCAPE_IN_LISTS;
using foundryboost::REG_NEWLINE_ALT;
using foundryboost::REG_PERL;
using foundryboost::REG_AWK;
using foundryboost::REG_GREP;
using foundryboost::REG_EGREP;
using foundryboost::REG_ASSERT;
using foundryboost::REG_INVARG;
using foundryboost::REG_ATOI;
using foundryboost::REG_ITOA;

using foundryboost::REG_NOTBOL;
using foundryboost::REG_NOTEOL;
using foundryboost::REG_STARTEND;

using foundryboost::reg_comp_flags;
using foundryboost::reg_exec_flags;
using foundryboost::regcompA;
using foundryboost::regerrorA;
using foundryboost::regexecA;
using foundryboost::regfreeA;

#ifndef BOOST_NO_WREGEX
using foundryboost::regcompW;
using foundryboost::regerrorW;
using foundryboost::regexecW;
using foundryboost::regfreeW;
using foundryboost::regex_tW;
#endif

using foundryboost::REG_NOERROR;
using foundryboost::REG_NOMATCH;
using foundryboost::REG_BADPAT;
using foundryboost::REG_ECOLLATE;
using foundryboost::REG_ECTYPE;
using foundryboost::REG_EESCAPE;
using foundryboost::REG_ESUBREG;
using foundryboost::REG_EBRACK;
using foundryboost::REG_EPAREN;
using foundryboost::REG_EBRACE;
using foundryboost::REG_BADBR;
using foundryboost::REG_ERANGE;
using foundryboost::REG_ESPACE;
using foundryboost::REG_BADRPT;
using foundryboost::REG_EEND;
using foundryboost::REG_ESIZE;
using foundryboost::REG_ERPAREN;
using foundryboost::REG_EMPTY;
using foundryboost::REG_E_MEMORY;
using foundryboost::REG_E_UNKNOWN;
using foundryboost::reg_errcode_t;

#endif /* __cplusplus */

#endif /* BOOST_RE_REGEX_H */




