// Copyright (c) 2016 Klemens D. Morgenstern
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_PROCESS_DETAIL_WINDOWS_JOB_WORKAROUND_HPP_
#define BOOST_PROCESS_DETAIL_WINDOWS_JOB_WORKAROUND_HPP_

#include <boost/winapi/config.hpp>
#include <boost/winapi/basic_types.hpp>
#include <boost/winapi/dll.hpp>
#include <boost/winapi/overlapped.hpp>

#if defined( BOOST_USE_WINDOWS_H )
#include <windows.h>
#else
extern "C"
{
BOOST_SYMBOL_IMPORT ::foundryboost::winapi::HANDLE_ BOOST_WINAPI_WINAPI_CC CreateIoCompletionPort(
        ::foundryboost::winapi::HANDLE_    FileHandle,
        ::foundryboost::winapi::HANDLE_    ExistingCompletionPort,
        ::foundryboost::winapi::ULONG_PTR_ CompletionKey,
        ::foundryboost::winapi::DWORD_     NumberOfConcurrentThreads
);

BOOST_SYMBOL_IMPORT ::foundryboost::winapi::BOOL_ BOOST_WINAPI_WINAPI_CC GetQueuedCompletionStatus(
        ::foundryboost::winapi::HANDLE_       CompletionPort,
        ::foundryboost::winapi::LPDWORD_      lpNumberOfBytes,
        ::foundryboost::winapi::ULONG_PTR_    *lpCompletionKey,
        _OVERLAPPED **lpOverlapped,
        ::foundryboost::winapi::DWORD_        dwMilliseconds
);

}
#endif
namespace foundryboost {} namespace boost = foundryboost; namespace foundryboost { namespace process { namespace detail { namespace windows { namespace workaround {

extern "C"
{

struct JOBOBJECT_ASSOCIATE_COMPLETION_PORT_
{
    ::foundryboost::winapi::PVOID_  CompletionKey;
    ::foundryboost::winapi::HANDLE_ CompletionPort;
};

constexpr static int JOB_OBJECT_MSG_END_OF_JOB_TIME_          = 1;
constexpr static int JOB_OBJECT_MSG_END_OF_PROCESS_TIME_      = 2;
constexpr static int JOB_OBJECT_MSG_ACTIVE_PROCESS_LIMIT_     = 3;
constexpr static int JOB_OBJECT_MSG_ACTIVE_PROCESS_ZERO_      = 4;
constexpr static int JOB_OBJECT_MSG_NEW_PROCESS_              = 6;
constexpr static int JOB_OBJECT_MSG_EXIT_PROCESS_             = 7;
constexpr static int JOB_OBJECT_MSG_ABNORMAL_EXIT_PROCESS_    = 8;
constexpr static int JOB_OBJECT_MSG_PROCESS_MEMORY_LIMIT_     = 9;
constexpr static int JOB_OBJECT_MSG_JOB_MEMORY_LIMIT_         = 10;
constexpr static int JOB_OBJECT_MSG_NOTIFICATION_LIMIT_       = 11;
constexpr static int JOB_OBJECT_MSG_JOB_CYCLE_TIME_LIMIT_     = 12;
constexpr static int JOB_OBJECT_MSG_SILO_TERMINATED_          = 13;

}

BOOST_FORCEINLINE ::foundryboost::winapi::BOOL_  get_queued_completion_status(
        ::foundryboost::winapi::HANDLE_       CompletionPort,
        ::foundryboost::winapi::LPDWORD_      lpNumberOfBytes,
        ::foundryboost::winapi::ULONG_PTR_    *lpCompletionKey,
        ::foundryboost::winapi::LPOVERLAPPED_ *lpOverlapped,
        ::foundryboost::winapi::DWORD_        dwMilliseconds)
{
    return ::GetQueuedCompletionStatus(
                CompletionPort,
                lpNumberOfBytes,
                lpCompletionKey,
                reinterpret_cast<::_OVERLAPPED**>(lpOverlapped),
                dwMilliseconds);
}

#if defined( BOOST_USE_WINDOWS_H )

constexpr auto static JobObjectExtendedLimitInformation_ = ::JobObjectExtendedLimitInformation;
constexpr auto static JobObjectAssociateCompletionPortInformation_ = ::JobObjectAssociateCompletionPortInformation;
constexpr auto static JobObjectBasicAccountingInformation_ = ::JobObjectBasicAccountingInformation;

using JOBOBJECT_BASIC_LIMIT_INFORMATION_ = ::JOBOBJECT_BASIC_LIMIT_INFORMATION;
using JOBOBJECTINFOCLASS_ = ::JOBOBJECTINFOCLASS;
using IO_COUNTERS_ = ::IO_COUNTERS;
using JOBOBJECT_EXTENDED_LIMIT_INFORMATION_ = ::JOBOBJECT_EXTENDED_LIMIT_INFORMATION;
using JOBOBJECT_BASIC_ACCOUNTING_INFORMATION_ = ::JOBOBJECT_BASIC_ACCOUNTING_INFORMATION;

inline ::foundryboost::winapi::BOOL_ query_information_job_object(
        ::foundryboost::winapi::HANDLE_ hJob,
        JOBOBJECTINFOCLASS_ JobObjectInfoClass,
        void * lpJobObjectInfo,
        ::foundryboost::winapi::DWORD_ cbJobObjectInfoLength,
        ::foundryboost::winapi::DWORD_ *lpReturnLength)
{
    return ::QueryInformationJobObject(hJob, JobObjectInfoClass, lpJobObjectInfo, cbJobObjectInfoLength, lpReturnLength);
}

inline ::foundryboost::winapi::BOOL_ set_information_job_object(
        ::foundryboost::winapi::HANDLE_ hJob,
        JOBOBJECTINFOCLASS_ JobObjectInfoClass,
        void * lpJobObjectInfo,
        ::foundryboost::winapi::DWORD_ cbJobObjectInfoLength)
{
    return ::SetInformationJobObject(hJob, JobObjectInfoClass, lpJobObjectInfo, cbJobObjectInfoLength);
}


#else

//this import workaround is to keep it a header-only library. and enums cannot be imported from the winapi.

extern "C"
{

typedef enum _JOBOBJECTINFOCLASS_
{
    JobObjectBasicAccountingInformation_ = 1,
    JobObjectBasicLimitInformation_,
    JobObjectBasicProcessIdList_,
    JobObjectBasicUIRestrictions_,
    JobObjectSecurityLimitInformation_,
    JobObjectEndOfJobTimeInformation_,
    JobObjectAssociateCompletionPortInformation_,
    JobObjectBasicAndIoAccountingInformation_,
    JobObjectExtendedLimitInformation_,
    JobObjectJobSetInformation_,
    JobObjectGroupInformation_,
    JobObjectNotificationLimitInformation_,
    JobObjectLimitViolationInformation_,
    JobObjectGroupInformationEx_,
    JobObjectCpuRateControlInformation_,
    JobObjectCompletionFilter_,
    JobObjectCompletionCounter_,
    JobObjectReserved1Information_ = 18,
    JobObjectReserved2Information_,
    JobObjectReserved3Information_,
    JobObjectReserved4Information_,
    JobObjectReserved5Information_,
    JobObjectReserved6Information_,
    JobObjectReserved7Information_,
    JobObjectReserved8Information_,
    MaxJobObjectInfoClass_
} JOBOBJECTINFOCLASS_;

typedef struct _JOBOBJECT_BASIC_LIMIT_INFORMATION_
{
    ::foundryboost::winapi::LARGE_INTEGER_ PerProcessUserTimeLimit;
    ::foundryboost::winapi::LARGE_INTEGER_ PerJobUserTimeLimit;
    ::foundryboost::winapi::DWORD_ LimitFlags;
    ::foundryboost::winapi::SIZE_T_ MinimumWorkingSetSize;
    ::foundryboost::winapi::SIZE_T_ MaximumWorkingSetSize;
    ::foundryboost::winapi::DWORD_ ActiveProcessLimit;
    ::foundryboost::winapi::ULONG_PTR_ Affinity;
    ::foundryboost::winapi::DWORD_ PriorityClass;
    ::foundryboost::winapi::DWORD_ SchedulingClass;
} JOBOBJECT_BASIC_LIMIT_INFORMATION_;


typedef struct _JOBOBJECT_BASIC_ACCOUNTING_INFORMATION_ {
    ::foundryboost::winapi::LARGE_INTEGER_ TotalUserTime;
    ::foundryboost::winapi::LARGE_INTEGER_ TotalKernelTime;
    ::foundryboost::winapi::LARGE_INTEGER_ ThisPeriodTotalUserTime;
    ::foundryboost::winapi::LARGE_INTEGER_ ThisPeriodTotalKernelTime;
    ::foundryboost::winapi::DWORD_         TotalPageFaultCount;
    ::foundryboost::winapi::DWORD_         TotalProcesses;
    ::foundryboost::winapi::DWORD_         ActiveProcesses;
    ::foundryboost::winapi::DWORD_         TotalTerminatedProcesses;
} JOBOBJECT_BASIC_ACCOUNTING_INFORMATION_;

typedef struct _IO_COUNTERS_
{
    ::foundryboost::winapi::ULONGLONG_ ReadOperationCount;
    ::foundryboost::winapi::ULONGLONG_ WriteOperationCount;
    ::foundryboost::winapi::ULONGLONG_ OtherOperationCount;
    ::foundryboost::winapi::ULONGLONG_ ReadTransferCount;
    ::foundryboost::winapi::ULONGLONG_ WriteTransferCount;
    ::foundryboost::winapi::ULONGLONG_ OtherTransferCount;
} IO_COUNTERS_;


typedef struct _JOBOBJECT_EXTENDED_LIMIT_INFORMATION_
{
    JOBOBJECT_BASIC_LIMIT_INFORMATION_ BasicLimitInformation;
    IO_COUNTERS_ IoInfo;
    ::foundryboost::winapi::SIZE_T_ ProcessMemoryLimit;
    ::foundryboost::winapi::SIZE_T_ JobMemoryLimit;
    ::foundryboost::winapi::SIZE_T_ PeakProcessMemoryUsed;
    ::foundryboost::winapi::SIZE_T_ PeakJobMemoryUsed;
} JOBOBJECT_EXTENDED_LIMIT_INFORMATION_;


/*BOOL WINAPI QueryInformationJobObject(
  _In_opt_  HANDLE             hJob,
  _In_      JOBOBJECTINFOCLASS JobObjectInfoClass,
  _Out_     LPVOID             lpJobObjectInfo,
  _In_      DWORD              cbJobObjectInfoLength,
  _Out_opt_ LPDWORD            lpReturnLength
);
 */
typedef ::foundryboost::winapi::BOOL_ (BOOST_WINAPI_WINAPI_CC *query_information_job_object_p)(
        ::foundryboost::winapi::HANDLE_,
        JOBOBJECTINFOCLASS_,
        void *,
        ::foundryboost::winapi::DWORD_,
        ::foundryboost::winapi::DWORD_ *);


inline ::foundryboost::winapi::BOOL_ query_information_job_object(
        ::foundryboost::winapi::HANDLE_ hJob,
        JOBOBJECTINFOCLASS_ JobObjectInfoClass,
        void *lpJobObjectInfo,
        ::foundryboost::winapi::DWORD_ cbJobObjectInfoLength,
        ::foundryboost::winapi::DWORD_ *lpReturnLength)
{
    static ::foundryboost::winapi::HMODULE_ h = ::foundryboost::winapi::get_module_handle(
            L"Kernel32.dll");
    static query_information_job_object_p f = reinterpret_cast<query_information_job_object_p>(::foundryboost::winapi::get_proc_address(
            h, "QueryInformationJobObject"));

    return (*f)(hJob, JobObjectInfoClass, lpJobObjectInfo,
                cbJobObjectInfoLength, lpReturnLength);
}

/*BOOL WINAPI SetInformationJobObject(
  _In_ HANDLE             hJob,
  _In_ JOBOBJECTINFOCLASS JobObjectInfoClass,
  _In_ LPVOID             lpJobObjectInfo,
  _In_ DWORD              cbJobObjectInfoLength
);*/

typedef ::foundryboost::winapi::BOOL_ (BOOST_WINAPI_WINAPI_CC *set_information_job_object_p)(
        ::foundryboost::winapi::HANDLE_,
        JOBOBJECTINFOCLASS_,
        void *,
        ::foundryboost::winapi::DWORD_);

}

inline ::foundryboost::winapi::BOOL_ set_information_job_object(
        ::foundryboost::winapi::HANDLE_ hJob,
        JOBOBJECTINFOCLASS_ JobObjectInfoClass,
        void *lpJobObjectInfo,
        ::foundryboost::winapi::DWORD_ cbJobObjectInfoLength)
{
    static ::foundryboost::winapi::HMODULE_ h = ::foundryboost::winapi::get_module_handle(
            L"Kernel32.dll");
    static set_information_job_object_p f = reinterpret_cast<set_information_job_object_p>(::foundryboost::winapi::get_proc_address(
            h, "SetInformationJobObject"));

    return (*f)(hJob, JobObjectInfoClass, lpJobObjectInfo,
                cbJobObjectInfoLength);
}

#endif

constexpr static ::foundryboost::winapi::DWORD_ JOB_OBJECT_LIMIT_BREAKAWAY_OK_ = 0x00000800;

}}}}}

#endif /* BOOST_PROCESS_DETAIL_WINDOWS_JOB_WORKAROUND_HPP_ */
