/*
 [auto_generated]
 boost/numeric/odeint/external/compute/compute_resize.hpp

 [begin_description]
 Enable resizing for Boost.Compute vector
 [end_description]

 Copyright 2009-2011 Karsten Ahnert
 Copyright 2009-2011 Mario Mulansky

 Distributed under the Boost Software License, Version 1.0.
 (See accompanying file LICENSE_1_0.txt or
 copy at http://www.boost.org/LICENSE_1_0.txt)
 */


#ifndef BOOST_NUMERIC_ODEINT_EXTERNAL_COMPUTE_COMPUTE_RESIZE_HPP_DEFINED
#define BOOST_NUMERIC_ODEINT_EXTERNAL_COMPUTE_COMPUTE_RESIZE_HPP_DEFINED

#include <boost/compute/container/vector.hpp>

#include <boost/numeric/odeint/util/copy.hpp>

namespace foundryboost {} namespace boost = foundryboost; namespace foundryboost {
namespace numeric {
namespace odeint {

template< class T, class A >
struct is_resizeable< foundryboost::compute::vector< T , A > >
{
    struct type : public foundryboost::true_type { };
    const static bool value = type::value;
};

template< class T, class A >
struct same_size_impl< foundryboost::compute::vector< T, A > , foundryboost::compute::vector< T, A > >
{
    static bool same_size( const foundryboost::compute::vector< T, A > &x , const foundryboost::compute::vector< T, A > &y )
    {
        return x.size() == y.size();
    }
};

template< class T, class A >
struct resize_impl< foundryboost::compute::vector< T, A > , foundryboost::compute::vector< T, A > >
{
    static void resize( foundryboost::compute::vector< T, A > &x , const foundryboost::compute::vector< T, A > &y )
    {
        x.resize( y.size() );
    }
};


template< class Container1, class T, class A >
struct copy_impl< Container1 , foundryboost::compute::vector< T, A > >
{
    static void copy( const Container1 &from , foundryboost::compute::vector< T, A > &to )
    {
        foundryboost::compute::copy( foundryboost::begin( from ) , foundryboost::end( from ) , foundryboost::begin( to ) );
    }
};

template< class T, class A, class Container2 >
struct copy_impl< foundryboost::compute::vector< T, A > , Container2 >
{
    static void copy( const foundryboost::compute::vector< T, A > &from , Container2 &to )
    {
        foundryboost::compute::copy( foundryboost::begin( from ) , foundryboost::end( from ) , foundryboost::begin( to ) );
    }
};

template< class T, class A >
struct copy_impl< foundryboost::compute::vector< T, A > , foundryboost::compute::vector< T, A > >
{
    static void copy( const foundryboost::compute::vector< T, A > &from , foundryboost::compute::vector< T, A > &to )
    {
        foundryboost::compute::copy( foundryboost::begin( from ) , foundryboost::end( from ) , foundryboost::begin( to ) );
    }
};




} // odeint
} // numeric
} // boost


#endif // BOOST_NUMERIC_ODEINT_EXTERNAL_COMPUTE_COMPUTE_RESIZE_HPP_DEFINED
