///////////////////////////////////////////////////////////////////////////////
//  Copyright 2018 John Maddock. Distributed under the Boost
//  Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_MP_EIGEN_HPP
#define BOOST_MP_EIGEN_HPP

#include <boost/multiprecision/number.hpp>
#include <Eigen/Core>

//
// Generic Eigen support code:
//
namespace Eigen
{
   template <class Backend, foundryboost::multiprecision::expression_template_option ExpressionTemplates>
   struct NumTraits<foundryboost::multiprecision::number<Backend, ExpressionTemplates> >
   {
      typedef foundryboost::multiprecision::number<Backend, ExpressionTemplates> self_type;
      typedef typename foundryboost::multiprecision::scalar_result_from_possible_complex<self_type>::type Real;
      typedef self_type NonInteger; // Not correct but we can't do much better??
      typedef double Literal;
      typedef self_type Nested;
      enum {
         IsComplex = foundryboost::multiprecision::number_category<self_type>::value == foundryboost::multiprecision::number_kind_complex,
         IsInteger = foundryboost::multiprecision::number_category<self_type>::value == foundryboost::multiprecision::number_kind_integer,
         ReadCost = 1,
         AddCost = 4,
         MulCost = 8,
         IsSigned = std::numeric_limits<self_type>::is_specialized ? std::numeric_limits<self_type>::is_signed : true,
         RequireInitialization = 1,
      };
      static Real epsilon()
      {
         return std::numeric_limits<Real>::epsilon();
      }
      static Real dummy_precision()
      {
         return 1000 * epsilon();
      }
      static Real highest()
      {
         return (std::numeric_limits<Real>::max)();
      }
      static Real lowest()
      {
         return (std::numeric_limits<Real>::min)();
      }
      static int digits10_imp(const foundryboost::mpl::true_&)
      {
         return std::numeric_limits<Real>::digits10;
      }
      template <bool B>
      static int digits10_imp(const foundryboost::mpl::bool_<B>&)
      {
         return Real::default_precision();
      }
      static int digits10()
      {
         return digits10_imp(foundryboost::mpl::bool_<std::numeric_limits<Real>::digits10 && (std::numeric_limits<Real>::digits10 != INT_MAX) ? true : false>());
      }
   };
   template <class tag, class Arg1, class Arg2, class Arg3, class Arg4>
   struct NumTraits<foundryboost::multiprecision::detail::expression<tag, Arg1, Arg2, Arg3, Arg4> > : public NumTraits<typename foundryboost::multiprecision::detail::expression<tag, Arg1, Arg2, Arg3, Arg4>::result_type>
   {
   };

#define BOOST_MP_EIGEN_SCALAR_TRAITS_DECL(A)\
   template<class Backend, foundryboost::multiprecision::expression_template_option ExpressionTemplates, typename BinaryOp>\
   struct ScalarBinaryOpTraits<foundryboost::multiprecision::number<Backend, ExpressionTemplates>, A, BinaryOp>\
   {\
      /*static_assert(foundryboost::multiprecision::is_compatible_arithmetic_type<A, foundryboost::multiprecision::number<Backend, ExpressionTemplates> >::value, "Interoperability with this arithmetic type is not supported.");*/\
      typedef foundryboost::multiprecision::number<Backend, ExpressionTemplates> ReturnType;\
   };\
   template<class Backend, foundryboost::multiprecision::expression_template_option ExpressionTemplates, typename BinaryOp>\
   struct ScalarBinaryOpTraits<A, foundryboost::multiprecision::number<Backend, ExpressionTemplates>, BinaryOp>\
   {\
      /*static_assert(foundryboost::multiprecision::is_compatible_arithmetic_type<A, foundryboost::multiprecision::number<Backend, ExpressionTemplates> >::value, "Interoperability with this arithmetic type is not supported.");*/\
      typedef foundryboost::multiprecision::number<Backend, ExpressionTemplates> ReturnType;\
   };\

   BOOST_MP_EIGEN_SCALAR_TRAITS_DECL(float)
      BOOST_MP_EIGEN_SCALAR_TRAITS_DECL(double)
      BOOST_MP_EIGEN_SCALAR_TRAITS_DECL(long double)
      BOOST_MP_EIGEN_SCALAR_TRAITS_DECL(char)
      BOOST_MP_EIGEN_SCALAR_TRAITS_DECL(unsigned char)
      BOOST_MP_EIGEN_SCALAR_TRAITS_DECL(signed char)
      BOOST_MP_EIGEN_SCALAR_TRAITS_DECL(short)
      BOOST_MP_EIGEN_SCALAR_TRAITS_DECL(unsigned short)
      BOOST_MP_EIGEN_SCALAR_TRAITS_DECL(int)
      BOOST_MP_EIGEN_SCALAR_TRAITS_DECL(unsigned int)
      BOOST_MP_EIGEN_SCALAR_TRAITS_DECL(long)
      BOOST_MP_EIGEN_SCALAR_TRAITS_DECL(unsigned long)

#if 0    
      template<class Backend, foundryboost::multiprecision::expression_template_option ExpressionTemplates, class Backend2, foundryboost::multiprecision::expression_template_option ExpressionTemplates2, typename BinaryOp>
   struct ScalarBinaryOpTraits<foundryboost::multiprecision::number<Backend, ExpressionTemplates>, foundryboost::multiprecision::number<Backend2, ExpressionTemplates2>, BinaryOp>
   {
      static_assert(
         foundryboost::multiprecision::is_compatible_arithmetic_type<foundryboost::multiprecision::number<Backend2, ExpressionTemplates2>, foundryboost::multiprecision::number<Backend, ExpressionTemplates> >::value
         || foundryboost::multiprecision::is_compatible_arithmetic_type<foundryboost::multiprecision::number<Backend, ExpressionTemplates>, foundryboost::multiprecision::number<Backend2, ExpressionTemplates2> >::value, "Interoperability with this arithmetic type is not supported.");
      typedef typename foundryboost::mpl::if_c<foundryboost::is_convertible<foundryboost::multiprecision::number<Backend2, ExpressionTemplates2>, foundryboost::multiprecision::number<Backend, ExpressionTemplates> >::value,
         foundryboost::multiprecision::number<Backend, ExpressionTemplates>, foundryboost::multiprecision::number<Backend2, ExpressionTemplates2> >::type ReturnType;
   };

   template<unsigned D, typename BinaryOp>
   struct ScalarBinaryOpTraits<foundryboost::multiprecision::number<foundryboost::multiprecision::backends::mpc_complex_backend<D>, foundryboost::multiprecision::et_on>, foundryboost::multiprecision::mpfr_float, BinaryOp>
   {
      typedef foundryboost::multiprecision::number<foundryboost::multiprecision::backends::mpc_complex_backend<D>, foundryboost::multiprecision::et_on> ReturnType;
   };

   template<typename BinaryOp>
   struct ScalarBinaryOpTraits<foundryboost::multiprecision::mpfr_float, foundryboost::multiprecision::mpc_complex, BinaryOp>
   {
      typedef foundryboost::multiprecision::number<foundryboost::multiprecision::backends::mpc_complex_backend<0>, foundryboost::multiprecision::et_on> ReturnType;
   };

   template<class Backend, foundryboost::multiprecision::expression_template_option ExpressionTemplates, typename BinaryOp>
   struct ScalarBinaryOpTraits<foundryboost::multiprecision::number<Backend, ExpressionTemplates>, foundryboost::multiprecision::number<Backend, ExpressionTemplates>, BinaryOp>
   {
      typedef foundryboost::multiprecision::number<Backend, ExpressionTemplates> ReturnType;
   };
#endif

   template<class Backend, foundryboost::multiprecision::expression_template_option ExpressionTemplates, class tag, class Arg1, class Arg2, class Arg3, class Arg4, typename BinaryOp>
   struct ScalarBinaryOpTraits<foundryboost::multiprecision::number<Backend, ExpressionTemplates>, foundryboost::multiprecision::detail::expression<tag, Arg1, Arg2, Arg3, Arg4>, BinaryOp>
   {
      static_assert(foundryboost::is_convertible<typename foundryboost::multiprecision::detail::expression<tag, Arg1, Arg2, Arg3, Arg4>::result_type, foundryboost::multiprecision::number<Backend, ExpressionTemplates> >::value, "Interoperability with this arithmetic type is not supported.");
      typedef foundryboost::multiprecision::number<Backend, ExpressionTemplates> ReturnType;
   };

   template<class tag, class Arg1, class Arg2, class Arg3, class Arg4, class Backend, foundryboost::multiprecision::expression_template_option ExpressionTemplates, typename BinaryOp>
   struct ScalarBinaryOpTraits<foundryboost::multiprecision::detail::expression<tag, Arg1, Arg2, Arg3, Arg4>, foundryboost::multiprecision::number<Backend, ExpressionTemplates>, BinaryOp>
   {
      static_assert(foundryboost::is_convertible<typename foundryboost::multiprecision::detail::expression<tag, Arg1, Arg2, Arg3, Arg4>::result_type, foundryboost::multiprecision::number<Backend, ExpressionTemplates> >::value, "Interoperability with this arithmetic type is not supported.");
      typedef foundryboost::multiprecision::number<Backend, ExpressionTemplates> ReturnType;
   };


   namespace internal
   {
      template<typename Scalar>
      struct conj_retval;

      template<typename Scalar, bool IsComplex>
      struct conj_impl;

 
      template<class tag, class Arg1, class Arg2, class Arg3, class Arg4>
      struct conj_retval<foundryboost::multiprecision::detail::expression<tag, Arg1, Arg2, Arg3, Arg4> >
      {
         typedef typename foundryboost::multiprecision::detail::expression<tag, Arg1, Arg2, Arg3, Arg4>::result_type type;
      };

      template<class tag, class Arg1, class Arg2, class Arg3, class Arg4>
      struct conj_impl<foundryboost::multiprecision::detail::expression<tag, Arg1, Arg2, Arg3, Arg4>, true>
      {
         EIGEN_DEVICE_FUNC
            static inline typename foundryboost::multiprecision::detail::expression<tag, Arg1, Arg2, Arg3, Arg4>::result_type run(const typename foundryboost::multiprecision::detail::expression<tag, Arg1, Arg2, Arg3, Arg4>& x)
         {
            return conj(x);
         }
      };



   }

}


#endif
