// Copyright John Maddock 2008-11.
// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_MATH_C_MACROS_IPP
#define BOOST_MATH_C_MACROS_IPP

// C99 Functions:
#ifdef acosh
#undef acosh
#endif
#define acosh foundryboost_acosh
#ifdef acoshf
#undef acoshf
#endif
#define acoshf foundryboost_acoshf
#ifdef acoshl
#undef acoshl
#endif
#define acoshl foundryboost_acoshl

#ifdef asinh
#undef asinh
#endif
#define asinh foundryboost_asinh
#ifdef asinhf
#undef asinhf
#endif
#define asinhf foundryboost_asinhf
#ifdef asinhl
#undef asinhl
#endif
#define asinhl foundryboost_asinhl

#ifdef atanh
#undef atanh
#endif
#define atanh foundryboost_atanh
#ifdef atanhf
#undef atanhf
#endif
#define atanhf foundryboost_atanhf
#ifdef atanhl
#undef atanhl
#endif
#define atanhl foundryboost_atanhl

#ifdef cbrt
#undef cbrt
#endif
#define cbrt foundryboost_cbrt
#ifdef cbrtf
#undef cbrtf
#endif
#define cbrtf foundryboost_cbrtf
#ifdef cbrtl
#undef cbrtl
#endif
#define cbrtl foundryboost_cbrtl

#ifdef copysign
#undef copysign
#endif
#define copysign foundryboost_copysign
#ifdef copysignf
#undef copysignf
#endif
#define copysignf foundryboost_copysignf
#ifdef copysignl
#undef copysignl
#endif
#define copysignl foundryboost_copysignl

#ifdef erf
#undef erf
#endif
#define erf foundryboost_erf
#ifdef erff
#undef erff
#endif
#define erff foundryboost_erff
#ifdef erfl
#undef erfl
#endif
#define erfl foundryboost_erfl

#ifdef erfc
#undef erfc
#endif
#define erfc foundryboost_erfc
#ifdef erfcf
#undef erfcf
#endif
#define erfcf foundryboost_erfcf
#ifdef erfcl
#undef erfcl
#endif
#define erfcl foundryboost_erfcl

#if 0
#ifdef exp2
#undef exp2
#endif
#define exp2 foundryboost_exp2
#ifdef exp2f
#undef exp2f
#endif
#define exp2f foundryboost_exp2f
#ifdef exp2l
#undef exp2l
#endif
#define exp2l foundryboost_exp2l
#endif

#ifdef expm1
#undef expm1
#endif
#define expm1 foundryboost_expm1
#ifdef expm1f
#undef expm1f
#endif
#define expm1f foundryboost_expm1f
#ifdef expm1l
#undef expm1l
#endif
#define expm1l foundryboost_expm1l

#if 0
#ifdef fdim
#undef fdim
#endif
#define fdim foundryboost_fdim
#ifdef fdimf
#undef fdimf
#endif
#define fdimf foundryboost_fdimf
#ifdef fdiml
#undef fdiml
#endif
#define fdiml foundryboost_fdiml
#ifdef acosh
#undef acosh
#endif
#define fma foundryboost_fma
#ifdef fmaf
#undef fmaf
#endif
#define fmaf foundryboost_fmaf
#ifdef fmal
#undef fmal
#endif
#define fmal foundryboost_fmal
#endif

#ifdef fmax
#undef fmax
#endif
#define fmax foundryboost_fmax
#ifdef fmaxf
#undef fmaxf
#endif
#define fmaxf foundryboost_fmaxf
#ifdef fmaxl
#undef fmaxl
#endif
#define fmaxl foundryboost_fmaxl

#ifdef fmin
#undef fmin
#endif
#define fmin foundryboost_fmin
#ifdef fminf
#undef fminf
#endif
#define fminf foundryboost_fminf
#ifdef fminl
#undef fminl
#endif
#define fminl foundryboost_fminl

#ifdef hypot
#undef hypot
#endif
#define hypot foundryboost_hypot
#ifdef hypotf
#undef hypotf
#endif
#define hypotf foundryboost_hypotf
#ifdef hypotl
#undef hypotl
#endif
#define hypotl foundryboost_hypotl

#if 0
#ifdef ilogb
#undef ilogb
#endif
#define ilogb foundryboost_ilogb
#ifdef ilogbf
#undef ilogbf
#endif
#define ilogbf foundryboost_ilogbf
#ifdef ilogbl
#undef ilogbl
#endif
#define ilogbl foundryboost_ilogbl
#endif

#ifdef lgamma
#undef lgamma
#endif
#define lgamma foundryboost_lgamma
#ifdef lgammaf
#undef lgammaf
#endif
#define lgammaf foundryboost_lgammaf
#ifdef lgammal
#undef lgammal
#endif
#define lgammal foundryboost_lgammal

#ifdef BOOST_HAS_LONG_LONG
#if 0
#ifdef llrint
#undef llrint
#endif
#define llrint foundryboost_llrint
#ifdef llrintf
#undef llrintf
#endif
#define llrintf foundryboost_llrintf
#ifdef llrintl
#undef llrintl
#endif
#define llrintl foundryboost_llrintl
#endif
#ifdef llround
#undef llround
#endif
#define llround foundryboost_llround
#ifdef llroundf
#undef llroundf
#endif
#define llroundf foundryboost_llroundf
#ifdef llroundl
#undef llroundl
#endif
#define llroundl foundryboost_llroundl
#endif

#ifdef log1p
#undef log1p
#endif
#define log1p foundryboost_log1p
#ifdef log1pf
#undef log1pf
#endif
#define log1pf foundryboost_log1pf
#ifdef log1pl
#undef log1pl
#endif
#define log1pl foundryboost_log1pl

#if 0
#ifdef log2
#undef log2
#endif
#define log2 foundryboost_log2
#ifdef log2f
#undef log2f
#endif
#define log2f foundryboost_log2f
#ifdef log2l
#undef log2l
#endif
#define log2l foundryboost_log2l

#ifdef logb
#undef logb
#endif
#define logb foundryboost_logb
#ifdef logbf
#undef logbf
#endif
#define logbf foundryboost_logbf
#ifdef logbl
#undef logbl
#endif
#define logbl foundryboost_logbl

#ifdef lrint
#undef lrint
#endif
#define lrint foundryboost_lrint
#ifdef lrintf
#undef lrintf
#endif
#define lrintf foundryboost_lrintf
#ifdef lrintl
#undef lrintl
#endif
#define lrintl foundryboost_lrintl
#endif

#ifdef lround
#undef lround
#endif
#define lround foundryboost_lround
#ifdef lroundf
#undef lroundf
#endif
#define lroundf foundryboost_lroundf
#ifdef lroundl
#undef lroundl
#endif
#define lroundl foundryboost_lroundl

#if 0
#ifdef nan
#undef nan
#endif
#define nan foundryboost_nan
#ifdef nanf
#undef nanf
#endif
#define nanf foundryboost_nanf
#ifdef nanl
#undef nanl
#endif
#define nanl foundryboost_nanl

#ifdef nearbyint
#undef nearbyint
#endif
#define nearbyint foundryboost_nearbyint
#ifdef nearbyintf
#undef nearbyintf
#endif
#define nearbyintf foundryboost_nearbyintf
#ifdef nearbyintl
#undef nearbyintl
#endif
#define nearbyintl foundryboost_nearbyintl
#endif

#ifdef nextafter
#undef nextafter
#endif
#define nextafter foundryboost_nextafter
#ifdef nextafterf
#undef nextafterf
#endif
#define nextafterf foundryboost_nextafterf
#ifdef nextafterl
#undef nextafterl
#endif
#define nextafterl foundryboost_nextafterl

#ifdef nexttoward
#undef nexttoward
#endif
#define nexttoward foundryboost_nexttoward
#ifdef nexttowardf
#undef nexttowardf
#endif
#define nexttowardf foundryboost_nexttowardf
#ifdef nexttowardl
#undef nexttowardl
#endif
#define nexttowardl foundryboost_nexttowardl

#if 0
#ifdef remainder
#undef remainder
#endif
#define remainder foundryboost_remainder
#ifdef remainderf
#undef remainderf
#endif
#define remainderf foundryboost_remainderf
#ifdef remainderl
#undef remainderl
#endif
#define remainderl foundryboost_remainderl

#ifdef remquo
#undef remquo
#endif
#define remquo foundryboost_remquo
#ifdef remquof
#undef remquof
#endif
#define remquof foundryboost_remquof
#ifdef remquol
#undef remquol
#endif
#define remquol foundryboost_remquol

#ifdef rint
#undef rint
#endif
#define rint foundryboost_rint
#ifdef rintf
#undef rintf
#endif
#define rintf foundryboost_rintf
#ifdef rintl
#undef rintl
#endif
#define rintl foundryboost_rintl
#endif

#ifdef round
#undef round
#endif
#define round foundryboost_round
#ifdef roundf
#undef roundf
#endif
#define roundf foundryboost_roundf
#ifdef roundl
#undef roundl
#endif
#define roundl foundryboost_roundl

#if 0
#ifdef scalbln
#undef scalbln
#endif
#define scalbln foundryboost_scalbln
#ifdef scalblnf
#undef scalblnf
#endif
#define scalblnf foundryboost_scalblnf
#ifdef scalblnl
#undef scalblnl
#endif
#define scalblnl foundryboost_scalblnl

#ifdef scalbn
#undef scalbn
#endif
#define scalbn foundryboost_scalbn
#ifdef scalbnf
#undef scalbnf
#endif
#define scalbnf foundryboost_scalbnf
#ifdef scalbnl
#undef scalbnl
#endif
#define scalbnl foundryboost_scalbnl
#endif

#ifdef tgamma
#undef tgamma
#endif
#define tgamma foundryboost_tgamma
#ifdef tgammaf
#undef tgammaf
#endif
#define tgammaf foundryboost_tgammaf
#ifdef tgammal
#undef tgammal
#endif
#define tgammal foundryboost_tgammal

#ifdef trunc
#undef trunc
#endif
#define trunc foundryboost_trunc
#ifdef truncf
#undef truncf
#endif
#define truncf foundryboost_truncf
#ifdef truncl
#undef truncl
#endif
#define truncl foundryboost_truncl

// [5.2.1.1] associated Laguerre polynomials:
#ifdef assoc_laguerre
#undef assoc_laguerre
#endif
#define assoc_laguerre foundryboost_assoc_laguerre
#ifdef assoc_laguerref
#undef assoc_laguerref
#endif
#define assoc_laguerref foundryboost_assoc_laguerref
#ifdef assoc_laguerrel
#undef assoc_laguerrel
#endif
#define assoc_laguerrel foundryboost_assoc_laguerrel

// [5.2.1.2] associated Legendre functions:
#ifdef assoc_legendre
#undef assoc_legendre
#endif
#define assoc_legendre foundryboost_assoc_legendre
#ifdef assoc_legendref
#undef assoc_legendref
#endif
#define assoc_legendref foundryboost_assoc_legendref
#ifdef assoc_legendrel
#undef assoc_legendrel
#endif
#define assoc_legendrel foundryboost_assoc_legendrel

// [5.2.1.3] beta function:
#ifdef beta
#undef beta
#endif
#define beta foundryboost_beta
#ifdef betaf
#undef betaf
#endif
#define betaf foundryboost_betaf
#ifdef betal
#undef betal
#endif
#define betal foundryboost_betal

// [5.2.1.4] (complete) elliptic integral of the first kind:
#ifdef comp_ellint_1
#undef comp_ellint_1
#endif
#define comp_ellint_1 foundryboost_comp_ellint_1
#ifdef comp_ellint_1f
#undef comp_ellint_1f
#endif
#define comp_ellint_1f foundryboost_comp_ellint_1f
#ifdef comp_ellint_1l
#undef comp_ellint_1l
#endif
#define comp_ellint_1l foundryboost_comp_ellint_1l

// [5.2.1.5] (complete) elliptic integral of the second kind:
#ifdef comp_ellint_2
#undef comp_ellint_2
#endif
#define comp_ellint_2 foundryboost_comp_ellint_2
#ifdef comp_ellint_2f
#undef comp_ellint_2f
#endif
#define comp_ellint_2f foundryboost_comp_ellint_2f
#ifdef comp_ellint_2l
#undef comp_ellint_2l
#endif
#define comp_ellint_2l foundryboost_comp_ellint_2l

// [5.2.1.6] (complete) elliptic integral of the third kind:
#ifdef comp_ellint_3
#undef comp_ellint_3
#endif
#define comp_ellint_3 foundryboost_comp_ellint_3
#ifdef comp_ellint_3f
#undef comp_ellint_3f
#endif
#define comp_ellint_3f foundryboost_comp_ellint_3f
#ifdef comp_ellint_3l
#undef comp_ellint_3l
#endif
#define comp_ellint_3l foundryboost_comp_ellint_3l

#if 0
// [5.2.1.7] confluent hypergeometric functions:
#ifdef conf_hyper
#undef conf_hyper
#endif
#define conf_hyper foundryboost_conf_hyper
#ifdef conf_hyperf
#undef conf_hyperf
#endif
#define conf_hyperf foundryboost_conf_hyperf
#ifdef conf_hyperl
#undef conf_hyperl
#endif
#define conf_hyperl foundryboost_conf_hyperl
#endif

// [5.2.1.8] regular modified cylindrical Bessel functions:
#ifdef cyl_bessel_i
#undef cyl_bessel_i
#endif
#define cyl_bessel_i foundryboost_cyl_bessel_i
#ifdef cyl_bessel_if
#undef cyl_bessel_if
#endif
#define cyl_bessel_if foundryboost_cyl_bessel_if
#ifdef cyl_bessel_il
#undef cyl_bessel_il
#endif
#define cyl_bessel_il foundryboost_cyl_bessel_il

// [5.2.1.9] cylindrical Bessel functions (of the first kind):
#ifdef cyl_bessel_j
#undef cyl_bessel_j
#endif
#define cyl_bessel_j foundryboost_cyl_bessel_j
#ifdef cyl_bessel_jf
#undef cyl_bessel_jf
#endif
#define cyl_bessel_jf foundryboost_cyl_bessel_jf
#ifdef cyl_bessel_jl
#undef cyl_bessel_jl
#endif
#define cyl_bessel_jl foundryboost_cyl_bessel_jl

// [5.2.1.10] irregular modified cylindrical Bessel functions:
#ifdef cyl_bessel_k
#undef cyl_bessel_k
#endif
#define cyl_bessel_k foundryboost_cyl_bessel_k
#ifdef cyl_bessel_kf
#undef cyl_bessel_kf
#endif
#define cyl_bessel_kf foundryboost_cyl_bessel_kf
#ifdef cyl_bessel_kl
#undef cyl_bessel_kl
#endif
#define cyl_bessel_kl foundryboost_cyl_bessel_kl

// [5.2.1.11] cylindrical Neumann functions BOOST_MATH_C99_THROW_SPEC;
// cylindrical Bessel functions (of the second kind):
#ifdef cyl_neumann
#undef cyl_neumann
#endif
#define cyl_neumann foundryboost_cyl_neumann
#ifdef cyl_neumannf
#undef cyl_neumannf
#endif
#define cyl_neumannf foundryboost_cyl_neumannf
#ifdef cyl_neumannl
#undef cyl_neumannl
#endif
#define cyl_neumannl foundryboost_cyl_neumannl

// [5.2.1.12] (incomplete) elliptic integral of the first kind:
#ifdef ellint_1
#undef ellint_1
#endif
#define ellint_1 foundryboost_ellint_1
#ifdef ellint_1f
#undef ellint_1f
#endif
#define ellint_1f foundryboost_ellint_1f
#ifdef ellint_1l
#undef ellint_1l
#endif
#define ellint_1l foundryboost_ellint_1l

// [5.2.1.13] (incomplete) elliptic integral of the second kind:
#ifdef ellint_2
#undef ellint_2
#endif
#define ellint_2 foundryboost_ellint_2
#ifdef ellint_2f
#undef ellint_2f
#endif
#define ellint_2f foundryboost_ellint_2f
#ifdef ellint_2l
#undef ellint_2l
#endif
#define ellint_2l foundryboost_ellint_2l

// [5.2.1.14] (incomplete) elliptic integral of the third kind:
#ifdef ellint_3
#undef ellint_3
#endif
#define ellint_3 foundryboost_ellint_3
#ifdef ellint_3f
#undef ellint_3f
#endif
#define ellint_3f foundryboost_ellint_3f
#ifdef ellint_3l
#undef ellint_3l
#endif
#define ellint_3l foundryboost_ellint_3l

// [5.2.1.15] exponential integral:
#ifdef expint
#undef expint
#endif
#define expint foundryboost_expint
#ifdef expintf
#undef expintf
#endif
#define expintf foundryboost_expintf
#ifdef expintl
#undef expintl
#endif
#define expintl foundryboost_expintl

// [5.2.1.16] Hermite polynomials:
#ifdef hermite
#undef hermite
#endif
#define hermite foundryboost_hermite
#ifdef hermitef
#undef hermitef
#endif
#define hermitef foundryboost_hermitef
#ifdef hermitel
#undef hermitel
#endif
#define hermitel foundryboost_hermitel

#if 0
// [5.2.1.17] hypergeometric functions:
#ifdef hyperg
#undef hyperg
#endif
#define hyperg foundryboost_hyperg
#ifdef hypergf
#undef hypergf
#endif
#define hypergf foundryboost_hypergf
#ifdef hypergl
#undef hypergl
#endif
#define hypergl foundryboost_hypergl
#endif

// [5.2.1.18] Laguerre polynomials:
#ifdef laguerre
#undef laguerre
#endif
#define laguerre foundryboost_laguerre
#ifdef laguerref
#undef laguerref
#endif
#define laguerref foundryboost_laguerref
#ifdef laguerrel
#undef laguerrel
#endif
#define laguerrel foundryboost_laguerrel

// [5.2.1.19] Legendre polynomials:
#ifdef legendre
#undef legendre
#endif
#define legendre foundryboost_legendre
#ifdef legendref
#undef legendref
#endif
#define legendref foundryboost_legendref
#ifdef legendrel
#undef legendrel
#endif
#define legendrel foundryboost_legendrel

// [5.2.1.20] Riemann zeta function:
#ifdef riemann_zeta
#undef riemann_zeta
#endif
#define riemann_zeta foundryboost_riemann_zeta
#ifdef riemann_zetaf
#undef riemann_zetaf
#endif
#define riemann_zetaf foundryboost_riemann_zetaf
#ifdef riemann_zetal
#undef riemann_zetal
#endif
#define riemann_zetal foundryboost_riemann_zetal

// [5.2.1.21] spherical Bessel functions (of the first kind):
#ifdef sph_bessel
#undef sph_bessel
#endif
#define sph_bessel foundryboost_sph_bessel
#ifdef sph_besself
#undef sph_besself
#endif
#define sph_besself foundryboost_sph_besself
#ifdef sph_bessell
#undef sph_bessell
#endif
#define sph_bessell foundryboost_sph_bessell

// [5.2.1.22] spherical associated Legendre functions:
#ifdef sph_legendre
#undef sph_legendre
#endif
#define sph_legendre foundryboost_sph_legendre
#ifdef sph_legendref
#undef sph_legendref
#endif
#define sph_legendref foundryboost_sph_legendref
#ifdef sph_legendrel
#undef sph_legendrel
#endif
#define sph_legendrel foundryboost_sph_legendrel

// [5.2.1.23] spherical Neumann functions BOOST_MATH_C99_THROW_SPEC;
// spherical Bessel functions (of the second kind):
#ifdef sph_neumann
#undef sph_neumann
#endif
#define sph_neumann foundryboost_sph_neumann
#ifdef sph_neumannf
#undef sph_neumannf
#endif
#define sph_neumannf foundryboost_sph_neumannf
#ifdef sph_neumannl
#undef sph_neumannl
#endif
#define sph_neumannl foundryboost_sph_neumannl

#endif // BOOST_MATH_C_MACROS_IPP
