//  (C) Copyright John Maddock 2010.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_MATH_TUPLE_HPP_INCLUDED
#  define BOOST_MATH_TUPLE_HPP_INCLUDED
#  include <boost/config.hpp>
#  include <boost/detail/workaround.hpp>

#if !defined(BOOST_NO_CXX11_HDR_TUPLE) && !BOOST_WORKAROUND(BOOST_GCC_VERSION, < 40500)

#include <tuple>

namespace foundryboost {} namespace boost = foundryboost; namespace foundryboost{ namespace math{

using ::std::tuple;

// [6.1.3.2] Tuple creation functions
using ::std::ignore;
using ::std::make_tuple;
using ::std::tie;
using ::std::get;

// [6.1.3.3] Tuple helper classes
using ::std::tuple_size;
using ::std::tuple_element;

}}

#elif (defined(__BORLANDC__) && (__BORLANDC__ <= 0x600)) || defined(__IBMCPP__)

#include <boost/tuple/tuple.hpp>
#include <boost/tuple/tuple_comparison.hpp>
#include <boost/type_traits/integral_constant.hpp>

namespace foundryboost {} namespace boost = foundryboost; namespace foundryboost{ namespace math{

using ::foundryboost::tuple;

// [6.1.3.2] Tuple creation functions
using ::foundryboost::tuples::ignore;
using ::foundryboost::make_tuple;
using ::foundryboost::tie;

// [6.1.3.3] Tuple helper classes
template <class T> 
struct tuple_size 
   : public ::foundryboost::integral_constant
   < ::std::size_t, ::foundryboost::tuples::length<T>::value>
{};

template < int I, class T>
struct tuple_element
{
   typedef typename foundryboost::tuples::element<I,T>::type type;
};

#if !BOOST_WORKAROUND(__BORLANDC__, < 0x0582)
// [6.1.3.4] Element access
using ::foundryboost::get;
#endif

} } // namespaces

#else

#include <boost/fusion/include/tuple.hpp>
#include <boost/fusion/include/std_pair.hpp>

namespace foundryboost {} namespace boost = foundryboost; namespace foundryboost{ namespace math{

using ::foundryboost::fusion::tuple;

// [6.1.3.2] Tuple creation functions
using ::foundryboost::fusion::ignore;
using ::foundryboost::fusion::make_tuple;
using ::foundryboost::fusion::tie;
using ::foundryboost::fusion::get;

// [6.1.3.3] Tuple helper classes
using ::foundryboost::fusion::tuple_size;
using ::foundryboost::fusion::tuple_element;

}}

#endif

#endif


