// Boost.Geometry

// Copyright (c) 2017-2018, Oracle and/or its affiliates.
// Contributed and/or modified by Adam Wulkiewicz, on behalf of Oracle

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)


#ifndef BOOST_GEOMETRY_PROJECTIONS_IAU2000_HPP
#define BOOST_GEOMETRY_PROJECTIONS_IAU2000_HPP


#include <boost/geometry/srs/projections/code.hpp>


namespace foundryboost {} namespace boost = foundryboost; namespace foundryboost { namespace geometry { namespace projections
{


#ifndef DOXYGEN_NO_DETAIL
namespace detail
{

    inline srs::dpar::parameters<> iau2000_to_parameters(int code)
    {
        using namespace srs::dpar;

        static const code_element arr[] = {
            {19900, srs::dpar::parameters<>(proj_longlat)(r,2439700)(no_defs)},
            {19901, srs::dpar::parameters<>(proj_longlat)(r,2439700)(no_defs)},
            //{19910},
            //{19911},
            //{19912},
            //{19913},
            {19914, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            {19915, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            {19916, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            {19917, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            {19918, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            {19919, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            {19920, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            {19921, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            {19960, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            {19961, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            {19962, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            {19963, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            {19964, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            {19965, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            {19966, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            {19967, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            //{19968},
            //{19969},
            //{19970},
            //{19971},
            {19972, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            {19973, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,2439700)(units_m)(no_defs)},
            //{19974},
            //{19975},
            //{19976},
            //{19977},
            //{19978},
            //{19979},
            {29900, srs::dpar::parameters<>(proj_longlat)(r,6051800)(no_defs)},
            {29901, srs::dpar::parameters<>(proj_longlat)(r,6051800)(no_defs)},
            //{29910},
            //{29911},
            //{29912},
            //{29913},
            {29914, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            {29915, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            {29916, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            {29917, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            {29918, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            {29919, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            {29920, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            {29921, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            {29960, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            {29961, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            {29962, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            {29963, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            {29964, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            {29965, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            {29966, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            {29967, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            //{29968},
            //{29969},
            //{29970},
            //{29971},
            {29972, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            {29973, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,6051800)(units_m)(no_defs)},
            //{29974},
            //{29975},
            //{29976},
            //{29977},
            //{29978},
            //{29979},
            {30100, srs::dpar::parameters<>(proj_longlat)(r,1737400)(no_defs)},
            {30101, srs::dpar::parameters<>(proj_longlat)(r,1737400)(no_defs)},
            //{30110},
            //{30111},
            //{30112},
            //{30113},
            {30114, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            {30115, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            {30116, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            {30117, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            {30118, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            {30119, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            {30120, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            {30121, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            {30160, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            {30161, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            {30162, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            {30163, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            {30164, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            {30165, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            {30166, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            {30167, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            //{30168},
            //{30169},
            //{30170},
            //{30171},
            {30172, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            {30173, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,1737400)(units_m)(no_defs)},
            //{30174},
            //{30175},
            //{30176},
            //{30177},
            //{30178},
            //{30179},
            {39900, srs::dpar::parameters<>(proj_longlat)(a,6378140)(b,6356750)(no_defs)},
            {39901, srs::dpar::parameters<>(proj_longlat)(a,6378140)(b,6356750)(no_defs)},
            //{39910},
            //{39911},
            //{39912},
            //{39913},
            {39914, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            {39915, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            {39916, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            {39917, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            {39918, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            {39919, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            {39920, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            {39921, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            {39960, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            {39961, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            {39962, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            {39963, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            {39964, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            {39965, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            {39966, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            {39967, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            //{39968},
            //{39969},
            //{39970},
            //{39971},
            {39972, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            {39973, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,6378140)(b,6356750)(units_m)(no_defs)},
            //{39974},
            //{39975},
            //{39976},
            //{39977},
            //{39978},
            //{39979},
            {40100, srs::dpar::parameters<>(proj_longlat)(a,13400)(b,9200)(no_defs)},
            {40101, srs::dpar::parameters<>(proj_longlat)(a,13400)(b,9200)(no_defs)},
            //{40110},
            //{40111},
            //{40112},
            //{40113},
            {40114, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            {40115, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            {40116, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            {40117, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            {40118, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            {40119, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            {40120, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            {40121, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            {40160, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            {40161, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            {40162, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            {40163, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            {40164, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            {40165, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            {40166, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            {40167, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            //{40168},
            //{40169},
            //{40170},
            //{40171},
            {40172, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            {40173, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,13400)(b,9200)(units_m)(no_defs)},
            //{40174},
            //{40175},
            //{40176},
            //{40177},
            //{40178},
            //{40179},
            {40200, srs::dpar::parameters<>(proj_longlat)(a,7500)(b,5200)(no_defs)},
            {40201, srs::dpar::parameters<>(proj_longlat)(a,7500)(b,5200)(no_defs)},
            //{40210},
            //{40211},
            //{40212},
            //{40213},
            {40214, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            {40215, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            {40216, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            {40217, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            {40218, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            {40219, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            {40220, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            {40221, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            {40260, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            {40261, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            {40262, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            {40263, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            {40264, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            {40265, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            {40266, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            {40267, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            //{40268},
            //{40269},
            //{40270},
            //{40271},
            {40272, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            {40273, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,7500)(b,5200)(units_m)(no_defs)},
            //{40274},
            //{40275},
            //{40276},
            //{40277},
            //{40278},
            //{40279},
            {49900, srs::dpar::parameters<>(proj_longlat)(a,3396190)(b,3376200)(no_defs)},
            {49901, srs::dpar::parameters<>(proj_longlat)(a,3396190)(b,3376200)(no_defs)},
            //{49910},
            //{49911},
            //{49912},
            //{49913},
            {49914, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            {49915, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            {49916, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            {49917, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            {49918, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            {49919, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            {49920, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            {49921, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            {49960, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            {49961, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            {49962, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            {49963, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            {49964, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            {49965, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            {49966, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            {49967, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            //{49968},
            //{49969},
            //{49970},
            //{49971},
            {49972, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            {49973, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,3396190)(b,3376200)(units_m)(no_defs)},
            //{49974},
            //{49975},
            //{49976},
            //{49977},
            //{49978},
            //{49979},
            {50100, srs::dpar::parameters<>(proj_longlat)(a,1829400)(b,1815700)(no_defs)},
            {50101, srs::dpar::parameters<>(proj_longlat)(a,1829400)(b,1815700)(no_defs)},
            //{50110},
            //{50111},
            //{50112},
            //{50113},
            {50114, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            {50115, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            {50116, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            {50117, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            {50118, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            {50119, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            {50120, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            {50121, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            {50160, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            {50161, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            {50162, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            {50163, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            {50164, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            {50165, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            {50166, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            {50167, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            //{50168},
            //{50169},
            //{50170},
            //{50171},
            {50172, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            {50173, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,1829400)(b,1815700)(units_m)(no_defs)},
            //{50174},
            //{50175},
            //{50176},
            //{50177},
            //{50178},
            //{50179},
            {50200, srs::dpar::parameters<>(proj_longlat)(a,1564130)(b,1560930)(no_defs)},
            {50201, srs::dpar::parameters<>(proj_longlat)(a,1564130)(b,1560930)(no_defs)},
            //{50210},
            //{50211},
            //{50212},
            //{50213},
            {50214, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            {50215, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            {50216, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            {50217, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            {50218, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            {50219, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            {50220, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            {50221, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            {50260, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            {50261, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            {50262, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            {50263, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            {50264, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            {50265, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            {50266, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            {50267, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            //{50268},
            //{50269},
            //{50270},
            //{50271},
            {50272, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            {50273, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,1564130)(b,1560930)(units_m)(no_defs)},
            //{50274},
            //{50275},
            //{50276},
            //{50277},
            //{50278},
            //{50279},
            {50300, srs::dpar::parameters<>(proj_longlat)(a,2632400)(b,2632350)(no_defs)},
            {50301, srs::dpar::parameters<>(proj_longlat)(a,2632400)(b,2632350)(no_defs)},
            //{50310},
            //{50311},
            //{50312},
            //{50313},
            {50314, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            {50315, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            {50316, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            {50317, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            {50318, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            {50319, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            {50320, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            {50321, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            {50360, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            {50361, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            {50362, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            {50363, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            {50364, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            {50365, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            {50366, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            {50367, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            //{50368},
            //{50369},
            //{50370},
            //{50371},
            {50372, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            {50373, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,2632400)(b,2632350)(units_m)(no_defs)},
            //{50374},
            //{50375},
            //{50376},
            //{50377},
            //{50378},
            //{50379},
            {50400, srs::dpar::parameters<>(proj_longlat)(a,2409400)(b,2409300)(no_defs)},
            {50401, srs::dpar::parameters<>(proj_longlat)(a,2409400)(b,2409300)(no_defs)},
            //{50410},
            //{50411},
            //{50412},
            //{50413},
            {50414, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            {50415, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            {50416, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            {50417, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            {50418, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            {50419, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            {50420, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            {50421, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            {50460, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            {50461, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            {50462, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            {50463, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            {50464, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            {50465, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            {50466, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            {50467, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            //{50468},
            //{50469},
            //{50470},
            //{50471},
            {50472, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            {50473, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,2409400)(b,2409300)(units_m)(no_defs)},
            //{50474},
            //{50475},
            //{50476},
            //{50477},
            //{50478},
            //{50479},
            {50500, srs::dpar::parameters<>(proj_longlat)(a,125000)(b,64000)(no_defs)},
            {50501, srs::dpar::parameters<>(proj_longlat)(a,125000)(b,64000)(no_defs)},
            //{50510},
            //{50511},
            //{50512},
            //{50513},
            {50514, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            {50515, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            {50516, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            {50517, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            {50518, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            {50519, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            {50520, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            {50521, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            {50560, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            {50561, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            {50562, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            {50563, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            {50564, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            {50565, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            {50566, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            {50567, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            //{50568},
            //{50569},
            //{50570},
            //{50571},
            {50572, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            {50573, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,125000)(b,64000)(units_m)(no_defs)},
            //{50574},
            //{50575},
            //{50576},
            //{50577},
            //{50578},
            //{50579},
            {50600, srs::dpar::parameters<>(proj_longlat)(r,85000)(no_defs)},
            {50601, srs::dpar::parameters<>(proj_longlat)(r,85000)(no_defs)},
            //{50610},
            //{50611},
            //{50612},
            //{50613},
            {50614, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            {50615, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            {50616, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            {50617, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            {50618, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            {50619, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            {50620, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            {50621, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            {50660, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            {50661, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            {50662, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            {50663, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            {50664, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            {50665, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            {50666, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            {50667, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            //{50668},
            //{50669},
            //{50670},
            //{50671},
            {50672, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            {50673, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,85000)(units_m)(no_defs)},
            //{50674},
            //{50675},
            //{50676},
            //{50677},
            //{50678},
            //{50679},
            {50700, srs::dpar::parameters<>(proj_longlat)(r,40000)(no_defs)},
            {50701, srs::dpar::parameters<>(proj_longlat)(r,40000)(no_defs)},
            //{50710},
            //{50711},
            //{50712},
            //{50713},
            {50714, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {50715, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {50716, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {50717, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {50718, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {50719, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {50720, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {50721, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {50760, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {50761, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {50762, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {50763, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {50764, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {50765, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {50766, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {50767, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            //{50768},
            //{50769},
            //{50770},
            //{50771},
            {50772, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {50773, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            //{50774},
            //{50775},
            //{50776},
            //{50777},
            //{50778},
            //{50779},
            {50800, srs::dpar::parameters<>(proj_longlat)(r,18000)(no_defs)},
            {50801, srs::dpar::parameters<>(proj_longlat)(r,18000)(no_defs)},
            //{50810},
            //{50811},
            //{50812},
            //{50813},
            {50814, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            {50815, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            {50816, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            {50817, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            {50818, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            {50819, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            {50820, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            {50821, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            {50860, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            {50861, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            {50862, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            {50863, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            {50864, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            {50865, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            {50866, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            {50867, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            //{50868},
            //{50869},
            //{50870},
            //{50871},
            {50872, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            {50873, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,18000)(units_m)(no_defs)},
            //{50874},
            //{50875},
            //{50876},
            //{50877},
            //{50878},
            //{50879},
            {50900, srs::dpar::parameters<>(proj_longlat)(r,14000)(no_defs)},
            {50901, srs::dpar::parameters<>(proj_longlat)(r,14000)(no_defs)},
            //{50910},
            //{50911},
            //{50912},
            //{50913},
            {50914, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            {50915, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            {50916, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            {50917, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            {50918, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            {50919, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            {50920, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            {50921, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            {50960, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            {50961, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            {50962, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            {50963, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            {50964, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            {50965, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            {50966, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            {50967, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            //{50968},
            //{50969},
            //{50970},
            //{50971},
            {50972, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            {50973, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,14000)(units_m)(no_defs)},
            //{50974},
            //{50975},
            //{50976},
            //{50977},
            //{50978},
            //{50979},
            {51000, srs::dpar::parameters<>(proj_longlat)(r,12000)(no_defs)},
            {51001, srs::dpar::parameters<>(proj_longlat)(r,12000)(no_defs)},
            //{51010},
            //{51011},
            //{51012},
            //{51013},
            {51014, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            {51015, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            {51016, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            {51017, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            {51018, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            {51019, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            {51020, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            {51021, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            {51060, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            {51061, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            {51062, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            {51063, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            {51064, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            {51065, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            {51066, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            {51067, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            //{51068},
            //{51069},
            //{51070},
            //{51071},
            {51072, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            {51073, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,12000)(units_m)(no_defs)},
            //{51074},
            //{51075},
            //{51076},
            //{51077},
            //{51078},
            //{51079},
            {51100, srs::dpar::parameters<>(proj_longlat)(r,15000)(no_defs)},
            {51101, srs::dpar::parameters<>(proj_longlat)(r,15000)(no_defs)},
            //{51110},
            //{51111},
            //{51112},
            //{51113},
            {51114, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {51115, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {51116, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {51117, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {51118, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {51119, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {51120, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {51121, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {51160, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {51161, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {51162, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {51163, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {51164, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {51165, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {51166, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {51167, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            //{51168},
            //{51169},
            //{51170},
            //{51171},
            {51172, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {51173, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            //{51174},
            //{51175},
            //{51176},
            //{51177},
            //{51178},
            //{51179},
            {51200, srs::dpar::parameters<>(proj_longlat)(r,10000)(no_defs)},
            {51201, srs::dpar::parameters<>(proj_longlat)(r,10000)(no_defs)},
            //{51210},
            //{51211},
            //{51212},
            //{51213},
            {51214, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {51215, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {51216, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {51217, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {51218, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {51219, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {51220, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {51221, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {51260, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {51261, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {51262, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {51263, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {51264, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {51265, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {51266, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {51267, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            //{51268},
            //{51269},
            //{51270},
            //{51271},
            {51272, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {51273, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            //{51274},
            //{51275},
            //{51276},
            //{51277},
            //{51278},
            //{51279},
            {51300, srs::dpar::parameters<>(proj_longlat)(r,5000)(no_defs)},
            {51301, srs::dpar::parameters<>(proj_longlat)(r,5000)(no_defs)},
            //{51310},
            //{51311},
            //{51312},
            //{51313},
            {51314, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            {51315, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            {51316, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            {51317, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            {51318, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            {51319, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            {51320, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            {51321, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            {51360, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            {51361, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            {51362, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            {51363, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            {51364, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            {51365, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            {51366, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            {51367, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            //{51368},
            //{51369},
            //{51370},
            //{51371},
            {51372, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            {51373, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,5000)(units_m)(no_defs)},
            //{51374},
            //{51375},
            //{51376},
            //{51377},
            //{51378},
            //{51379},
            {51400, srs::dpar::parameters<>(proj_longlat)(a,58000)(b,42000)(no_defs)},
            {51401, srs::dpar::parameters<>(proj_longlat)(a,58000)(b,42000)(no_defs)},
            //{51410},
            //{51411},
            //{51412},
            //{51413},
            {51414, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            {51415, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            {51416, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            {51417, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            {51418, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            {51419, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            {51420, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            {51421, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            {51460, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            {51461, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            {51462, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            {51463, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            {51464, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            {51465, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            {51466, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            {51467, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            //{51468},
            //{51469},
            //{51470},
            //{51471},
            {51472, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            {51473, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,58000)(b,42000)(units_m)(no_defs)},
            //{51474},
            //{51475},
            //{51476},
            //{51477},
            //{51478},
            //{51479},
            {51500, srs::dpar::parameters<>(proj_longlat)(a,10000)(b,7000)(no_defs)},
            {51501, srs::dpar::parameters<>(proj_longlat)(a,10000)(b,7000)(no_defs)},
            //{51510},
            //{51511},
            //{51512},
            //{51513},
            {51514, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            {51515, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            {51516, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            {51517, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            {51518, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            {51519, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            {51520, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            {51521, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            {51560, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            {51561, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            {51562, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            {51563, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            {51564, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            {51565, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            {51566, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            {51567, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            //{51568},
            //{51569},
            //{51570},
            //{51571},
            {51572, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            {51573, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,10000)(b,7000)(units_m)(no_defs)},
            //{51574},
            //{51575},
            //{51576},
            //{51577},
            //{51578},
            //{51579},
            {51600, srs::dpar::parameters<>(proj_longlat)(r,21500)(no_defs)},
            {51601, srs::dpar::parameters<>(proj_longlat)(r,21500)(no_defs)},
            //{51610},
            //{51611},
            //{51612},
            //{51613},
            {51614, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            {51615, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            {51616, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            {51617, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            {51618, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            {51619, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            {51620, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            {51621, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            {51660, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            {51661, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            {51662, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            {51663, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            {51664, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            {51665, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            {51666, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            {51667, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            //{51668},
            //{51669},
            //{51670},
            //{51671},
            {51672, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            {51673, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,21500)(units_m)(no_defs)},
            //{51674},
            //{51675},
            //{51676},
            //{51677},
            //{51678},
            //{51679},
            {59900, srs::dpar::parameters<>(proj_longlat)(a,71492000)(b,66854000)(no_defs)},
            {59901, srs::dpar::parameters<>(proj_longlat)(a,71492000)(b,66854000)(no_defs)},
            //{59910},
            //{59911},
            //{59912},
            //{59913},
            {59914, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            {59915, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            {59916, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            {59917, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            {59918, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            {59919, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            {59920, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            {59921, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            {59960, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            {59961, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            {59962, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            {59963, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            {59964, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            {59965, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            {59966, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            {59967, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            //{59968},
            //{59969},
            //{59970},
            //{59971},
            {59972, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            {59973, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,71492000)(b,66854000)(units_m)(no_defs)},
            //{59974},
            //{59975},
            //{59976},
            //{59977},
            //{59978},
            //{59979},
            {60100, srs::dpar::parameters<>(proj_longlat)(a,209100)(b,191400)(no_defs)},
            {60101, srs::dpar::parameters<>(proj_longlat)(a,209100)(b,191400)(no_defs)},
            //{60110},
            //{60111},
            //{60112},
            //{60113},
            {60114, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            {60115, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            {60116, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            {60117, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            {60118, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            {60119, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            {60120, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            {60121, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            {60160, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            {60161, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            {60162, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            {60163, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            {60164, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            {60165, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            {60166, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            {60167, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            //{60168},
            //{60169},
            //{60170},
            //{60171},
            {60172, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            {60173, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,209100)(b,191400)(units_m)(no_defs)},
            //{60174},
            //{60175},
            //{60176},
            //{60177},
            //{60178},
            //{60179},
            {60200, srs::dpar::parameters<>(proj_longlat)(a,256300)(b,244600)(no_defs)},
            {60201, srs::dpar::parameters<>(proj_longlat)(a,256300)(b,244600)(no_defs)},
            //{60210},
            //{60211},
            //{60212},
            //{60213},
            {60214, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            {60215, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            {60216, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            {60217, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            {60218, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            {60219, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            {60220, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            {60221, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            {60260, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            {60261, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            {60262, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            {60263, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            {60264, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            {60265, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            {60266, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            {60267, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            //{60268},
            //{60269},
            //{60270},
            //{60271},
            {60272, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            {60273, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,256300)(b,244600)(units_m)(no_defs)},
            //{60274},
            //{60275},
            //{60276},
            //{60277},
            //{60278},
            //{60279},
            {60300, srs::dpar::parameters<>(proj_longlat)(a,535600)(b,525800)(no_defs)},
            {60301, srs::dpar::parameters<>(proj_longlat)(a,535600)(b,525800)(no_defs)},
            //{60310},
            //{60311},
            //{60312},
            //{60313},
            {60314, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            {60315, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            {60316, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            {60317, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            {60318, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            {60319, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            {60320, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            {60321, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            {60360, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            {60361, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            {60362, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            {60363, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            {60364, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            {60365, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            {60366, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            {60367, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            //{60368},
            //{60369},
            //{60370},
            //{60371},
            {60372, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            {60373, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,535600)(b,525800)(units_m)(no_defs)},
            //{60374},
            //{60375},
            //{60376},
            //{60377},
            //{60378},
            //{60379},
            {60400, srs::dpar::parameters<>(proj_longlat)(r,560000)(no_defs)},
            {60401, srs::dpar::parameters<>(proj_longlat)(r,560000)(no_defs)},
            //{60410},
            //{60411},
            //{60412},
            //{60413},
            {60414, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            {60415, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            {60416, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            {60417, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            {60418, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            {60419, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            {60420, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            {60421, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            {60460, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            {60461, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            {60462, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            {60463, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            {60464, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            {60465, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            {60466, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            {60467, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            //{60468},
            //{60469},
            //{60470},
            //{60471},
            {60472, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            {60473, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,560000)(units_m)(no_defs)},
            //{60474},
            //{60475},
            //{60476},
            //{60477},
            //{60478},
            //{60479},
            {60500, srs::dpar::parameters<>(proj_longlat)(r,764000)(no_defs)},
            {60501, srs::dpar::parameters<>(proj_longlat)(r,764000)(no_defs)},
            //{60510},
            //{60511},
            //{60512},
            //{60513},
            {60514, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            {60515, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            {60516, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            {60517, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            {60518, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            {60519, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            {60520, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            {60521, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            {60560, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            {60561, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            {60562, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            {60563, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            {60564, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            {60565, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            {60566, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            {60567, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            //{60568},
            //{60569},
            //{60570},
            //{60571},
            {60572, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            {60573, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,764000)(units_m)(no_defs)},
            //{60574},
            //{60575},
            //{60576},
            //{60577},
            //{60578},
            //{60579},
            {60600, srs::dpar::parameters<>(proj_longlat)(r,2575000)(no_defs)},
            {60601, srs::dpar::parameters<>(proj_longlat)(r,2575000)(no_defs)},
            //{60610},
            //{60611},
            //{60612},
            //{60613},
            {60614, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            {60615, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            {60616, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            {60617, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            {60618, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            {60619, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            {60620, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            {60621, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            {60660, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            {60661, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            {60662, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            {60663, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            {60664, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            {60665, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            {60666, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            {60667, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            //{60668},
            //{60669},
            //{60670},
            //{60671},
            {60672, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            {60673, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,2575000)(units_m)(no_defs)},
            //{60674},
            //{60675},
            //{60676},
            //{60677},
            //{60678},
            //{60679},
            {60700, srs::dpar::parameters<>(proj_longlat)(a,164000)(b,107000)(no_defs)},
            {60701, srs::dpar::parameters<>(proj_longlat)(a,164000)(b,107000)(no_defs)},
            //{60710},
            //{60711},
            //{60712},
            //{60713},
            {60714, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            {60715, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            {60716, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            {60717, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            {60718, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            {60719, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            {60720, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            {60721, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            {60760, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            {60761, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            {60762, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            {60763, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            {60764, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            {60765, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            {60766, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            {60767, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            //{60768},
            //{60769},
            //{60770},
            //{60771},
            {60772, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            {60773, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,164000)(b,107000)(units_m)(no_defs)},
            //{60774},
            //{60775},
            //{60776},
            //{60777},
            //{60778},
            //{60779},
            {60800, srs::dpar::parameters<>(proj_longlat)(r,718000)(no_defs)},
            {60801, srs::dpar::parameters<>(proj_longlat)(r,718000)(no_defs)},
            //{60810},
            //{60811},
            //{60812},
            //{60813},
            {60814, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            {60815, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            {60816, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            {60817, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            {60818, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            {60819, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            {60820, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            {60821, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            {60860, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            {60861, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            {60862, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            {60863, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            {60864, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            {60865, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            {60866, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            {60867, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            //{60868},
            //{60869},
            //{60870},
            //{60871},
            {60872, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            {60873, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,718000)(units_m)(no_defs)},
            //{60874},
            //{60875},
            //{60876},
            //{60877},
            //{60878},
            //{60879},
            {60900, srs::dpar::parameters<>(proj_longlat)(a,115000)(b,105000)(no_defs)},
            {60901, srs::dpar::parameters<>(proj_longlat)(a,115000)(b,105000)(no_defs)},
            //{60910},
            //{60911},
            //{60912},
            //{60913},
            {60914, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            {60915, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            {60916, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            {60917, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            {60918, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            {60919, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            {60920, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            {60921, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            {60960, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            {60961, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            {60962, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            {60963, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            {60964, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            {60965, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            {60966, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            {60967, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            //{60968},
            //{60969},
            //{60970},
            //{60971},
            {60972, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            {60973, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,115000)(b,105000)(units_m)(no_defs)},
            //{60974},
            //{60975},
            //{60976},
            //{60977},
            //{60978},
            //{60979},
            {61000, srs::dpar::parameters<>(proj_longlat)(a,97000)(b,77000)(no_defs)},
            {61001, srs::dpar::parameters<>(proj_longlat)(a,97000)(b,77000)(no_defs)},
            //{61010},
            //{61011},
            //{61012},
            //{61013},
            {61014, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            {61015, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            {61016, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            {61017, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            {61018, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            {61019, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            {61020, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            {61021, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            {61060, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            {61061, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            {61062, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            {61063, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            {61064, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            {61065, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            {61066, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            {61067, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            //{61068},
            //{61069},
            //{61070},
            //{61071},
            {61072, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            {61073, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,97000)(b,77000)(units_m)(no_defs)},
            //{61074},
            //{61075},
            //{61076},
            //{61077},
            //{61078},
            //{61079},
            {61100, srs::dpar::parameters<>(proj_longlat)(a,69000)(b,55000)(no_defs)},
            {61101, srs::dpar::parameters<>(proj_longlat)(a,69000)(b,55000)(no_defs)},
            //{61110},
            //{61111},
            //{61112},
            //{61113},
            {61114, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            {61115, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            {61116, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            {61117, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            {61118, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            {61119, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            {61120, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            {61121, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            {61160, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            {61161, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            {61162, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            {61163, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            {61164, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            {61165, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            {61166, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            {61167, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            //{61168},
            //{61169},
            //{61170},
            //{61171},
            {61172, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            {61173, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,69000)(b,55000)(units_m)(no_defs)},
            //{61174},
            //{61175},
            //{61176},
            //{61177},
            //{61178},
            //{61179},
            {61200, srs::dpar::parameters<>(proj_longlat)(r,16000)(no_defs)},
            {61201, srs::dpar::parameters<>(proj_longlat)(r,16000)(no_defs)},
            //{61210},
            //{61211},
            //{61212},
            //{61213},
            {61214, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            {61215, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            {61216, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            {61217, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            {61218, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            {61219, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            {61220, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            {61221, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            {61260, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            {61261, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            {61262, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            {61263, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            {61264, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            {61265, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            {61266, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            {61267, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            //{61268},
            //{61269},
            //{61270},
            //{61271},
            {61272, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            {61273, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,16000)(units_m)(no_defs)},
            //{61274},
            //{61275},
            //{61276},
            //{61277},
            //{61278},
            //{61279},
            {61300, srs::dpar::parameters<>(proj_longlat)(a,15000)(b,7500)(no_defs)},
            {61301, srs::dpar::parameters<>(proj_longlat)(a,15000)(b,7500)(no_defs)},
            //{61310},
            //{61311},
            //{61312},
            //{61313},
            {61314, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            {61315, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            {61316, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            {61317, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            {61318, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            {61319, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            {61320, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            {61321, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            {61360, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            {61361, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            {61362, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            {61363, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            {61364, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            {61365, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            {61366, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            {61367, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            //{61368},
            //{61369},
            //{61370},
            //{61371},
            {61372, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            {61373, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,7500)(units_m)(no_defs)},
            //{61374},
            //{61375},
            //{61376},
            //{61377},
            //{61378},
            //{61379},
            {61400, srs::dpar::parameters<>(proj_longlat)(a,15000)(b,8000)(no_defs)},
            {61401, srs::dpar::parameters<>(proj_longlat)(a,15000)(b,8000)(no_defs)},
            //{61410},
            //{61411},
            //{61412},
            //{61413},
            {61414, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            {61415, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            {61416, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            {61417, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            {61418, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            {61419, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            {61420, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            {61421, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            {61460, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            {61461, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            {61462, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            {61463, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            {61464, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            {61465, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            {61466, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            {61467, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            //{61468},
            //{61469},
            //{61470},
            //{61471},
            {61472, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            {61473, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,15000)(b,8000)(units_m)(no_defs)},
            //{61474},
            //{61475},
            //{61476},
            //{61477},
            //{61478},
            //{61479},
            {61500, srs::dpar::parameters<>(proj_longlat)(a,18500)(b,13500)(no_defs)},
            {61501, srs::dpar::parameters<>(proj_longlat)(a,18500)(b,13500)(no_defs)},
            //{61510},
            //{61511},
            //{61512},
            //{61513},
            {61514, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            {61515, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            {61516, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            {61517, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            {61518, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            {61519, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            {61520, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            {61521, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            {61560, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            {61561, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            {61562, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            {61563, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            {61564, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            {61565, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            {61566, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            {61567, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            //{61568},
            //{61569},
            //{61570},
            //{61571},
            {61572, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            {61573, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,18500)(b,13500)(units_m)(no_defs)},
            //{61574},
            //{61575},
            //{61576},
            //{61577},
            //{61578},
            //{61579},
            {61600, srs::dpar::parameters<>(proj_longlat)(a,74000)(b,34000)(no_defs)},
            {61601, srs::dpar::parameters<>(proj_longlat)(a,74000)(b,34000)(no_defs)},
            //{61610},
            //{61611},
            //{61612},
            //{61613},
            {61614, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            {61615, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            {61616, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            {61617, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            {61618, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            {61619, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            {61620, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            {61621, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            {61660, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            {61661, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            {61662, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            {61663, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            {61664, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            {61665, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            {61666, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            {61667, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            //{61668},
            //{61669},
            //{61670},
            //{61671},
            {61672, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            {61673, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,74000)(b,34000)(units_m)(no_defs)},
            //{61674},
            //{61675},
            //{61676},
            //{61677},
            //{61678},
            //{61679},
            {61700, srs::dpar::parameters<>(proj_longlat)(a,55000)(b,31000)(no_defs)},
            {61701, srs::dpar::parameters<>(proj_longlat)(a,55000)(b,31000)(no_defs)},
            //{61710},
            //{61711},
            //{61712},
            //{61713},
            {61714, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            {61715, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            {61716, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            {61717, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            {61718, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            {61719, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            {61720, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            {61721, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            {61760, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            {61761, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            {61762, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            {61763, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            {61764, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            {61765, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            {61766, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            {61767, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            //{61768},
            //{61769},
            //{61770},
            //{61771},
            {61772, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            {61773, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,55000)(b,31000)(units_m)(no_defs)},
            //{61774},
            //{61775},
            //{61776},
            //{61777},
            //{61778},
            //{61779},
            {61800, srs::dpar::parameters<>(proj_longlat)(r,10000)(no_defs)},
            {61801, srs::dpar::parameters<>(proj_longlat)(r,10000)(no_defs)},
            //{61810},
            //{61811},
            //{61812},
            //{61813},
            {61814, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {61815, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {61816, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {61817, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {61818, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {61819, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {61820, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {61821, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {61860, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {61861, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {61862, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {61863, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {61864, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {61865, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {61866, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {61867, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            //{61868},
            //{61869},
            //{61870},
            //{61871},
            {61872, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            {61873, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,10000)(units_m)(no_defs)},
            //{61874},
            //{61875},
            //{61876},
            //{61877},
            //{61878},
            //{61879},
            {69900, srs::dpar::parameters<>(proj_longlat)(a,60268000)(b,54364000)(no_defs)},
            {69901, srs::dpar::parameters<>(proj_longlat)(a,60268000)(b,54364000)(no_defs)},
            //{69910},
            //{69911},
            //{69912},
            //{69913},
            {69914, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            {69915, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            {69916, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            {69917, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            {69918, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            {69919, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            {69920, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            {69921, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            {69960, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            {69961, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            {69962, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            {69963, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            {69964, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            {69965, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            {69966, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            {69967, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            //{69968},
            //{69969},
            //{69970},
            //{69971},
            {69972, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            {69973, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,60268000)(b,54364000)(units_m)(no_defs)},
            //{69974},
            //{69975},
            //{69976},
            //{69977},
            //{69978},
            //{69979},
            {70100, srs::dpar::parameters<>(proj_longlat)(a,581100)(b,577700)(no_defs)},
            {70101, srs::dpar::parameters<>(proj_longlat)(a,581100)(b,577700)(no_defs)},
            //{70110},
            //{70111},
            //{70112},
            //{70113},
            {70114, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            {70115, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            {70116, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            {70117, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            {70118, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            {70119, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            {70120, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            {70121, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            {70160, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            {70161, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            {70162, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            {70163, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            {70164, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            {70165, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            {70166, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            {70167, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            //{70168},
            //{70169},
            //{70170},
            //{70171},
            {70172, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            {70173, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,581100)(b,577700)(units_m)(no_defs)},
            //{70174},
            //{70175},
            //{70176},
            //{70177},
            //{70178},
            //{70179},
            {70200, srs::dpar::parameters<>(proj_longlat)(r,584700)(no_defs)},
            {70201, srs::dpar::parameters<>(proj_longlat)(r,584700)(no_defs)},
            //{70210},
            //{70211},
            //{70212},
            //{70213},
            {70214, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            {70215, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            {70216, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            {70217, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            {70218, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            {70219, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            {70220, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            {70221, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            {70260, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            {70261, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            {70262, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            {70263, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            {70264, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            {70265, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            {70266, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            {70267, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            //{70268},
            //{70269},
            //{70270},
            //{70271},
            {70272, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            {70273, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,584700)(units_m)(no_defs)},
            //{70274},
            //{70275},
            //{70276},
            //{70277},
            //{70278},
            //{70279},
            {70300, srs::dpar::parameters<>(proj_longlat)(r,788900)(no_defs)},
            {70301, srs::dpar::parameters<>(proj_longlat)(r,788900)(no_defs)},
            //{70310},
            //{70311},
            //{70312},
            //{70313},
            {70314, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            {70315, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            {70316, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            {70317, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            {70318, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            {70319, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            {70320, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            {70321, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            {70360, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            {70361, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            {70362, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            {70363, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            {70364, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            {70365, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            {70366, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            {70367, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            //{70368},
            //{70369},
            //{70370},
            //{70371},
            {70372, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            {70373, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,788900)(units_m)(no_defs)},
            //{70374},
            //{70375},
            //{70376},
            //{70377},
            //{70378},
            //{70379},
            {70400, srs::dpar::parameters<>(proj_longlat)(r,761400)(no_defs)},
            {70401, srs::dpar::parameters<>(proj_longlat)(r,761400)(no_defs)},
            //{70410},
            //{70411},
            //{70412},
            //{70413},
            {70414, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            {70415, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            {70416, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            {70417, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            {70418, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            {70419, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            {70420, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            {70421, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            {70460, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            {70461, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            {70462, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            {70463, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            {70464, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            {70465, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            {70466, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            {70467, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            //{70468},
            //{70469},
            //{70470},
            //{70471},
            {70472, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            {70473, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,761400)(units_m)(no_defs)},
            //{70474},
            //{70475},
            //{70476},
            //{70477},
            //{70478},
            //{70479},
            {70500, srs::dpar::parameters<>(proj_longlat)(a,240400)(b,232900)(no_defs)},
            {70501, srs::dpar::parameters<>(proj_longlat)(a,240400)(b,232900)(no_defs)},
            //{70510},
            //{70511},
            //{70512},
            //{70513},
            {70514, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            {70515, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            {70516, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            {70517, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            {70518, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            {70519, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            {70520, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            {70521, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            {70560, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            {70561, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            {70562, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            {70563, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            {70564, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            {70565, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            {70566, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            {70567, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            //{70568},
            //{70569},
            //{70570},
            //{70571},
            {70572, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            {70573, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,240400)(b,232900)(units_m)(no_defs)},
            //{70574},
            //{70575},
            //{70576},
            //{70577},
            //{70578},
            //{70579},
            {70600, srs::dpar::parameters<>(proj_longlat)(r,13000)(no_defs)},
            {70601, srs::dpar::parameters<>(proj_longlat)(r,13000)(no_defs)},
            //{70610},
            //{70611},
            //{70612},
            //{70613},
            {70614, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            {70615, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            {70616, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            {70617, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            {70618, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            {70619, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            {70620, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            {70621, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            {70660, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            {70661, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            {70662, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            {70663, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            {70664, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            {70665, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            {70666, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            {70667, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            //{70668},
            //{70669},
            //{70670},
            //{70671},
            {70672, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            {70673, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,13000)(units_m)(no_defs)},
            //{70674},
            //{70675},
            //{70676},
            //{70677},
            //{70678},
            //{70679},
            {70700, srs::dpar::parameters<>(proj_longlat)(r,15000)(no_defs)},
            {70701, srs::dpar::parameters<>(proj_longlat)(r,15000)(no_defs)},
            //{70710},
            //{70711},
            //{70712},
            //{70713},
            {70714, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {70715, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {70716, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {70717, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {70718, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {70719, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {70720, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {70721, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {70760, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {70761, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {70762, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {70763, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {70764, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {70765, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {70766, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {70767, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            //{70768},
            //{70769},
            //{70770},
            //{70771},
            {70772, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            {70773, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,15000)(units_m)(no_defs)},
            //{70774},
            //{70775},
            //{70776},
            //{70777},
            //{70778},
            //{70779},
            {70800, srs::dpar::parameters<>(proj_longlat)(r,21000)(no_defs)},
            {70801, srs::dpar::parameters<>(proj_longlat)(r,21000)(no_defs)},
            //{70810},
            //{70811},
            //{70812},
            //{70813},
            {70814, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            {70815, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            {70816, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            {70817, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            {70818, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            {70819, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            {70820, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            {70821, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            {70860, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            {70861, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            {70862, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            {70863, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            {70864, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            {70865, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            {70866, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            {70867, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            //{70868},
            //{70869},
            //{70870},
            //{70871},
            {70872, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            {70873, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,21000)(units_m)(no_defs)},
            //{70874},
            //{70875},
            //{70876},
            //{70877},
            //{70878},
            //{70879},
            {70900, srs::dpar::parameters<>(proj_longlat)(r,31000)(no_defs)},
            {70901, srs::dpar::parameters<>(proj_longlat)(r,31000)(no_defs)},
            //{70910},
            //{70911},
            //{70912},
            //{70913},
            {70914, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            {70915, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            {70916, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            {70917, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            {70918, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            {70919, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            {70920, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            {70921, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            {70960, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            {70961, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            {70962, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            {70963, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            {70964, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            {70965, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            {70966, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            {70967, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            //{70968},
            //{70969},
            //{70970},
            //{70971},
            {70972, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            {70973, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,31000)(units_m)(no_defs)},
            //{70974},
            //{70975},
            //{70976},
            //{70977},
            //{70978},
            //{70979},
            {71000, srs::dpar::parameters<>(proj_longlat)(r,27000)(no_defs)},
            {71001, srs::dpar::parameters<>(proj_longlat)(r,27000)(no_defs)},
            //{71010},
            //{71011},
            //{71012},
            //{71013},
            {71014, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71015, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71016, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71017, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71018, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71019, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71020, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71021, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71060, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71061, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71062, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71063, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71064, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71065, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71066, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71067, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            //{71068},
            //{71069},
            //{71070},
            //{71071},
            {71072, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71073, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            //{71074},
            //{71075},
            //{71076},
            //{71077},
            //{71078},
            //{71079},
            {71100, srs::dpar::parameters<>(proj_longlat)(r,42000)(no_defs)},
            {71101, srs::dpar::parameters<>(proj_longlat)(r,42000)(no_defs)},
            //{71110},
            //{71111},
            //{71112},
            //{71113},
            {71114, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            {71115, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            {71116, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            {71117, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            {71118, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            {71119, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            {71120, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            {71121, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            {71160, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            {71161, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            {71162, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            {71163, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            {71164, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            {71165, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            {71166, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            {71167, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            //{71168},
            //{71169},
            //{71170},
            //{71171},
            {71172, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            {71173, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,42000)(units_m)(no_defs)},
            //{71174},
            //{71175},
            //{71176},
            //{71177},
            //{71178},
            //{71179},
            {71200, srs::dpar::parameters<>(proj_longlat)(r,54000)(no_defs)},
            {71201, srs::dpar::parameters<>(proj_longlat)(r,54000)(no_defs)},
            //{71210},
            //{71211},
            //{71212},
            //{71213},
            {71214, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            {71215, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            {71216, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            {71217, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            {71218, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            {71219, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            {71220, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            {71221, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            {71260, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            {71261, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            {71262, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            {71263, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            {71264, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            {71265, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            {71266, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            {71267, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            //{71268},
            //{71269},
            //{71270},
            //{71271},
            {71272, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            {71273, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,54000)(units_m)(no_defs)},
            //{71274},
            //{71275},
            //{71276},
            //{71277},
            //{71278},
            //{71279},
            {71300, srs::dpar::parameters<>(proj_longlat)(r,27000)(no_defs)},
            {71301, srs::dpar::parameters<>(proj_longlat)(r,27000)(no_defs)},
            //{71310},
            //{71311},
            //{71312},
            //{71313},
            {71314, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71315, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71316, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71317, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71318, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71319, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71320, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71321, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71360, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71361, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71362, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71363, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71364, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71365, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71366, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71367, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            //{71368},
            //{71369},
            //{71370},
            //{71371},
            {71372, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            {71373, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,27000)(units_m)(no_defs)},
            //{71374},
            //{71375},
            //{71376},
            //{71377},
            //{71378},
            //{71379},
            {71400, srs::dpar::parameters<>(proj_longlat)(r,33000)(no_defs)},
            {71401, srs::dpar::parameters<>(proj_longlat)(r,33000)(no_defs)},
            //{71410},
            //{71411},
            //{71412},
            //{71413},
            {71414, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            {71415, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            {71416, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            {71417, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            {71418, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            {71419, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            {71420, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            {71421, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            {71460, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            {71461, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            {71462, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            {71463, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            {71464, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            {71465, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            {71466, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            {71467, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            //{71468},
            //{71469},
            //{71470},
            //{71471},
            {71472, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            {71473, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,33000)(units_m)(no_defs)},
            //{71474},
            //{71475},
            //{71476},
            //{71477},
            //{71478},
            //{71479},
            {71500, srs::dpar::parameters<>(proj_longlat)(r,77000)(no_defs)},
            {71501, srs::dpar::parameters<>(proj_longlat)(r,77000)(no_defs)},
            //{71510},
            //{71511},
            //{71512},
            //{71513},
            {71514, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            {71515, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            {71516, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            {71517, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            {71518, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            {71519, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            {71520, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            {71521, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            {71560, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            {71561, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            {71562, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            {71563, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            {71564, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            {71565, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            {71566, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            {71567, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            //{71568},
            //{71569},
            //{71570},
            //{71571},
            {71572, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            {71573, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,77000)(units_m)(no_defs)},
            //{71574},
            //{71575},
            //{71576},
            //{71577},
            //{71578},
            //{71579},
            {79900, srs::dpar::parameters<>(proj_longlat)(a,25559000)(b,24973000)(no_defs)},
            {79901, srs::dpar::parameters<>(proj_longlat)(a,25559000)(b,24973000)(no_defs)},
            //{79910},
            //{79911},
            //{79912},
            //{79913},
            {79914, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            {79915, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            {79916, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            {79917, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            {79918, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            {79919, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            {79920, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            {79921, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            {79960, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            {79961, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            {79962, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            {79963, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            {79964, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            {79965, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            {79966, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            {79967, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            //{79968},
            //{79969},
            //{79970},
            //{79971},
            {79972, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            {79973, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,25559000)(b,24973000)(units_m)(no_defs)},
            //{79974},
            //{79975},
            //{79976},
            //{79977},
            //{79978},
            //{79979},
            {80100, srs::dpar::parameters<>(proj_longlat)(r,1352600)(no_defs)},
            {80101, srs::dpar::parameters<>(proj_longlat)(r,1352600)(no_defs)},
            //{80110},
            //{80111},
            //{80112},
            //{80113},
            {80114, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            {80115, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            {80116, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            {80117, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            {80118, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            {80119, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            {80120, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            {80121, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            {80160, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            {80161, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            {80162, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            {80163, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            {80164, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            {80165, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            {80166, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            {80167, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            //{80168},
            //{80169},
            //{80170},
            //{80171},
            {80172, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            {80173, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,1352600)(units_m)(no_defs)},
            //{80174},
            //{80175},
            //{80176},
            //{80177},
            //{80178},
            //{80179},
            {80200, srs::dpar::parameters<>(proj_longlat)(r,170000)(no_defs)},
            {80201, srs::dpar::parameters<>(proj_longlat)(r,170000)(no_defs)},
            //{80210},
            //{80211},
            //{80212},
            //{80213},
            {80214, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            {80215, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            {80216, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            {80217, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            {80218, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            {80219, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            {80220, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            {80221, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            {80260, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            {80261, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            {80262, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            {80263, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            {80264, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            {80265, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            {80266, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            {80267, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            //{80268},
            //{80269},
            //{80270},
            //{80271},
            {80272, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            {80273, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,170000)(units_m)(no_defs)},
            //{80274},
            //{80275},
            //{80276},
            //{80277},
            //{80278},
            //{80279},
            {80300, srs::dpar::parameters<>(proj_longlat)(r,29000)(no_defs)},
            {80301, srs::dpar::parameters<>(proj_longlat)(r,29000)(no_defs)},
            //{80310},
            //{80311},
            //{80312},
            //{80313},
            {80314, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            {80315, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            {80316, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            {80317, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            {80318, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            {80319, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            {80320, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            {80321, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            {80360, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            {80361, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            {80362, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            {80363, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            {80364, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            {80365, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            {80366, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            {80367, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            //{80368},
            //{80369},
            //{80370},
            //{80371},
            {80372, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            {80373, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,29000)(units_m)(no_defs)},
            //{80374},
            //{80375},
            //{80376},
            //{80377},
            //{80378},
            //{80379},
            {80400, srs::dpar::parameters<>(proj_longlat)(r,40000)(no_defs)},
            {80401, srs::dpar::parameters<>(proj_longlat)(r,40000)(no_defs)},
            //{80410},
            //{80411},
            //{80412},
            //{80413},
            {80414, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {80415, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {80416, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {80417, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {80418, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {80419, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {80420, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {80421, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {80460, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {80461, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {80462, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {80463, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {80464, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {80465, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {80466, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {80467, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            //{80468},
            //{80469},
            //{80470},
            //{80471},
            {80472, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            {80473, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,40000)(units_m)(no_defs)},
            //{80474},
            //{80475},
            //{80476},
            //{80477},
            //{80478},
            //{80479},
            {80500, srs::dpar::parameters<>(proj_longlat)(r,74000)(no_defs)},
            {80501, srs::dpar::parameters<>(proj_longlat)(r,74000)(no_defs)},
            //{80510},
            //{80511},
            //{80512},
            //{80513},
            {80514, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            {80515, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            {80516, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            {80517, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            {80518, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            {80519, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            {80520, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            {80521, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            {80560, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            {80561, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            {80562, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            {80563, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            {80564, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            {80565, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            {80566, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            {80567, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            //{80568},
            //{80569},
            //{80570},
            //{80571},
            {80572, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            {80573, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,74000)(units_m)(no_defs)},
            //{80574},
            //{80575},
            //{80576},
            //{80577},
            //{80578},
            //{80579},
            {80600, srs::dpar::parameters<>(proj_longlat)(r,79000)(no_defs)},
            {80601, srs::dpar::parameters<>(proj_longlat)(r,79000)(no_defs)},
            //{80610},
            //{80611},
            //{80612},
            //{80613},
            {80614, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            {80615, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            {80616, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            {80617, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            {80618, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            {80619, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            {80620, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            {80621, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            {80660, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            {80661, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            {80662, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            {80663, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            {80664, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            {80665, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            {80666, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            {80667, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            //{80668},
            //{80669},
            //{80670},
            //{80671},
            {80672, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            {80673, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,79000)(units_m)(no_defs)},
            //{80674},
            //{80675},
            //{80676},
            //{80677},
            //{80678},
            //{80679},
            {80700, srs::dpar::parameters<>(proj_longlat)(r,96000)(no_defs)},
            {80701, srs::dpar::parameters<>(proj_longlat)(r,96000)(no_defs)},
            //{80710},
            //{80711},
            //{80712},
            //{80713},
            {80714, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            {80715, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            {80716, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            {80717, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            {80718, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            {80719, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            {80720, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            {80721, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            {80760, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            {80761, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            {80762, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            {80763, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            {80764, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            {80765, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            {80766, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            {80767, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            //{80768},
            //{80769},
            //{80770},
            //{80771},
            {80772, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            {80773, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,96000)(units_m)(no_defs)},
            //{80774},
            //{80775},
            //{80776},
            //{80777},
            //{80778},
            //{80779},
            {80800, srs::dpar::parameters<>(proj_longlat)(a,218000)(b,201000)(no_defs)},
            {80801, srs::dpar::parameters<>(proj_longlat)(a,218000)(b,201000)(no_defs)},
            //{80810},
            //{80811},
            //{80812},
            //{80813},
            {80814, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            {80815, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            {80816, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            {80817, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            {80818, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            {80819, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            {80820, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            {80821, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            {80860, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            {80861, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            {80862, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            {80863, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            {80864, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            {80865, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            {80866, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            {80867, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            //{80868},
            //{80869},
            //{80870},
            //{80871},
            {80872, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            {80873, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,218000)(b,201000)(units_m)(no_defs)},
            //{80874},
            //{80875},
            //{80876},
            //{80877},
            //{80878},
            //{80879},
            {89900, srs::dpar::parameters<>(proj_longlat)(a,24764000)(b,24341000)(no_defs)},
            {89901, srs::dpar::parameters<>(proj_longlat)(a,24764000)(b,24341000)(no_defs)},
            //{89910},
            //{89911},
            //{89912},
            //{89913},
            {89914, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            {89915, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            {89916, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            {89917, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            {89918, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            {89919, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            {89920, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            {89921, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            {89960, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            {89961, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            {89962, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            {89963, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            {89964, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            {89965, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            {89966, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            {89967, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            //{89968},
            //{89969},
            //{89970},
            //{89971},
            {89972, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            {89973, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(a,24764000)(b,24341000)(units_m)(no_defs)},
            //{89974},
            //{89975},
            //{89976},
            //{89977},
            //{89978},
            //{89979},
            {90100, srs::dpar::parameters<>(proj_longlat)(r,593000)(no_defs)},
            {90101, srs::dpar::parameters<>(proj_longlat)(r,593000)(no_defs)},
            //{90110},
            //{90111},
            //{90112},
            //{90113},
            {90114, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            {90115, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            {90116, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            {90117, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            {90118, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            {90119, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            {90120, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            {90121, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            {90160, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            {90161, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            {90162, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            {90163, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            {90164, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            {90165, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            {90166, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            {90167, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            //{90168},
            //{90169},
            //{90170},
            //{90171},
            {90172, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            {90173, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,593000)(units_m)(no_defs)},
            //{90174},
            //{90175},
            //{90176},
            //{90177},
            //{90178},
            //{90179},
            {99900, srs::dpar::parameters<>(proj_longlat)(r,1195000)(no_defs)},
            {99901, srs::dpar::parameters<>(proj_longlat)(r,1195000)(no_defs)},
            //{99910},
            //{99911},
            //{99912},
            //{99913},
            {99914, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            {99915, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            {99916, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            {99917, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            {99918, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            {99919, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            {99920, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            {99921, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            {99960, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            {99961, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            {99962, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            {99963, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            {99964, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            {99965, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            {99966, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            {99967, srs::dpar::parameters<>(proj_ortho)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            //{99968},
            //{99969},
            //{99970},
            //{99971},
            {99972, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            {99973, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,1195000)(units_m)(no_defs)},
            //{99974},
            //{99975},
            //{99976},
            //{99977},
            //{99978},
            //{99979}
        };

        const code_element * first = arr;
        const code_element * last = arr + sizeof(arr) / sizeof(code_element);
        const code_element * el = binary_find_code_element(first, last, code);

        return el != last ? el->parameters : srs::dpar::parameters<>();
    }

}
#endif // DOXYGEN_NO_DETAIL


}}} // namespace foundryboost::geometry::projections

#endif
