// Boost.Geometry

// Copyright (c) 2017-2018, Oracle and/or its affiliates.
// Contributed and/or modified by Adam Wulkiewicz, on behalf of Oracle

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_GEOMETRY_PROJECTIONS_ESRI_TRAITS_HPP
#define BOOST_GEOMETRY_PROJECTIONS_ESRI_TRAITS_HPP


#include <boost/geometry/core/tags.hpp>

#include <boost/geometry/srs/projections/factory.hpp>
#include <boost/geometry/srs/projections/impl/projects.hpp>
#include <boost/geometry/srs/projections/spar.hpp>
#include <boost/geometry/srs/projections/srid_traits.hpp>


namespace foundryboost {} namespace boost = foundryboost; namespace foundryboost { namespace geometry { namespace projections
{

#ifndef DOXYGEN_NO_DETAIL
namespace detail
{

/*!
    \brief ESRI traits
    \details With help of the ESRI traits library users can statically use projections
        or coordinate systems specifying an ESRI code. The correct projections for transformations
        are used automically then, still keeping static polymorphism.
    \ingroup projection
    \tparam ESRI esri code
*/
template <int ESRI>
struct esri_traits
{
    // Specializations define:
    // - type to get projection type
    // - function par to get parameters
};

BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37001) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_wgs66,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37002) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378166),srs::spar::b<>(6356784.283607107)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37003) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378150),srs::spar::b<>(6356768.337244385)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37004) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_fschr60m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37005) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378270),srs::spar::b<>(6356794.343434343)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37006) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6377295.664),srs::spar::b<>(6356094.667915204)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37007) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6376896),srs::spar::b<>(6355834.846687363)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37008) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(6370997)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37201) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37202) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6377276.345),srs::spar::b<>(6356075.41314024)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37203) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6377301.243),srs::spar::b<>(6356100.230165384)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37204) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37205) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37206) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk80,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37207) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_fschr60m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37208) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk80,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37211) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk80,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37212) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37213) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37214) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37215) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37216) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37217) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37218) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37219) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37220) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk66,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37221) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37222) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37223) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378249.2),srs::spar::b<>(6356514.999904194)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37224) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37226) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37227) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37228) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk80,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37229) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378270),srs::spar::b<>(6356794.343434343)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37230) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37231) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_aust_sa,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37232) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37233) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37234) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37235) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37237) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37238) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37239) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk66,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37240) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk80,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37241) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37242) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37243) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk66,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37245) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37246) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37247) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37249) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37250) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37251) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37252) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk66,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37253) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37254) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk80,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37255) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_bessel,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37257) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_krass,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37259) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 37260) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk66,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53001)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53002) srs::spar::parameters<srs::spar::proj_eqc,srs::spar::lat_ts<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_eqc(),srs::spar::lat_ts<>(60),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53003) srs::spar::parameters<srs::spar::proj_mill,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r_au,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_mill(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r_au(),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53004) srs::spar::parameters<srs::spar::proj_merc,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_merc(),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53008) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53009) srs::spar::parameters<srs::spar::proj_moll,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_moll(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53010) srs::spar::parameters<srs::spar::proj_eck6,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_eck6(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53011)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53012) srs::spar::parameters<srs::spar::proj_eck4,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_eck4(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53013)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53014)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53015)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53016) srs::spar::parameters<srs::spar::proj_gall,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_gall(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53017)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53018)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53019)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53021) srs::spar::parameters<srs::spar::proj_poly,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_poly(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53022)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53023)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53024) srs::spar::parameters<srs::spar::proj_bonne,srs::spar::lon_0<>,srs::spar::lat_1<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_bonne(),srs::spar::lon_0<>(0),srs::spar::lat_1<>(60),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53025) srs::spar::parameters<srs::spar::proj_omerc,srs::spar::lat_0<>,srs::spar::lon_1<>,srs::spar::lat_1<>,srs::spar::lon_2<>,srs::spar::lat_2<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_omerc(),srs::spar::lat_0<>(40),srs::spar::lon_1<>(0),srs::spar::lat_1<>(0),srs::spar::lon_2<>(0),srs::spar::lat_2<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53026) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53027) srs::spar::parameters<srs::spar::proj_eqdc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_eqdc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::lat_1<>(60),srs::spar::lat_2<>(60),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53028) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53029) srs::spar::parameters<srs::spar::proj_vandg,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r_au,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_vandg(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r_au(),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53030) srs::spar::parameters<srs::spar::proj_robin,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_robin(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53031) srs::spar::parameters<srs::spar::proj_tpeqd,srs::spar::lat_1<>,srs::spar::lon_1<>,srs::spar::lat_2<>,srs::spar::lon_2<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tpeqd(),srs::spar::lat_1<>(0),srs::spar::lon_1<>(0),srs::spar::lat_2<>(60),srs::spar::lon_2<>(60),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 53032) srs::spar::parameters<srs::spar::proj_aeqd,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aeqd(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54001)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54002) srs::spar::parameters<srs::spar::proj_eqc,srs::spar::lat_ts<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_eqc(),srs::spar::lat_ts<>(60),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54003) srs::spar::parameters<srs::spar::proj_mill,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r_au,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_mill(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54004) srs::spar::parameters<srs::spar::proj_merc,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_merc(),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54008) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54009) srs::spar::parameters<srs::spar::proj_moll,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_moll(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54010) srs::spar::parameters<srs::spar::proj_eck6,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_eck6(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54011)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54012) srs::spar::parameters<srs::spar::proj_eck4,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_eck4(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54013)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54014)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54015)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54016) srs::spar::parameters<srs::spar::proj_gall,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_gall(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54017)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54018)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54019)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54021) srs::spar::parameters<srs::spar::proj_poly,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_poly(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54022)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54023)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54024) srs::spar::parameters<srs::spar::proj_bonne,srs::spar::lon_0<>,srs::spar::lat_1<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_bonne(),srs::spar::lon_0<>(0),srs::spar::lat_1<>(60),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54025) srs::spar::parameters<srs::spar::proj_omerc,srs::spar::lat_0<>,srs::spar::lon_1<>,srs::spar::lat_1<>,srs::spar::lon_2<>,srs::spar::lat_2<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_omerc(),srs::spar::lat_0<>(40),srs::spar::lon_1<>(0),srs::spar::lat_1<>(0),srs::spar::lon_2<>(0),srs::spar::lat_2<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54026) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54027) srs::spar::parameters<srs::spar::proj_eqdc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_eqdc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::lat_1<>(60),srs::spar::lat_2<>(60),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54028) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54029) srs::spar::parameters<srs::spar::proj_vandg,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r_au,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_vandg(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54030) srs::spar::parameters<srs::spar::proj_robin,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_robin(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54031) srs::spar::parameters<srs::spar::proj_tpeqd,srs::spar::lat_1<>,srs::spar::lon_1<>,srs::spar::lat_2<>,srs::spar::lon_2<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tpeqd(),srs::spar::lat_1<>(0),srs::spar::lon_1<>(0),srs::spar::lat_2<>(60),srs::spar::lon_2<>(60),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 54032) srs::spar::parameters<srs::spar::proj_aeqd,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aeqd(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 65061) srs::spar::parameters<srs::spar::proj_poly,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_poly(),srs::spar::lat_0<>(13.47246635277778),srs::spar::lon_0<>(-144.7487507055556),srs::spar::x_0<>(50000.00000000001),srs::spar::y_0<>(50000.00000000001),srs::spar::ellps_clrk66(),srs::spar::datum_nad27(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 65161) srs::spar::parameters<srs::spar::proj_poly,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_poly(),srs::spar::lat_0<>(13.47246635277778),srs::spar::lon_0<>(-144.7487507055556),srs::spar::x_0<>(50000),srs::spar::y_0<>(50000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102001) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(50),srs::spar::lat_2<>(70),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-96),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102002) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(50),srs::spar::lat_2<>(70),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-96),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102003) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(29.5),srs::spar::lat_2<>(45.5),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-96),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102004) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33),srs::spar::lat_2<>(45),srs::spar::lat_0<>(39),srs::spar::lon_0<>(-96),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102005) srs::spar::parameters<srs::spar::proj_eqdc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_eqdc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::lat_1<>(33),srs::spar::lat_2<>(45),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102006) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(55),srs::spar::lat_2<>(65),srs::spar::lat_0<>(50),srs::spar::lon_0<>(-154),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102007) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(8),srs::spar::lat_2<>(18),srs::spar::lat_0<>(13),srs::spar::lon_0<>(-157),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102008) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(20),srs::spar::lat_2<>(60),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-96),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102009) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(20),srs::spar::lat_2<>(60),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-96),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102010) srs::spar::parameters<srs::spar::proj_eqdc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_eqdc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::lat_1<>(20),srs::spar::lat_2<>(60),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102011) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102012) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30),srs::spar::lat_2<>(62),srs::spar::lat_0<>(0),srs::spar::lon_0<>(105),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102013) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(43),srs::spar::lat_2<>(62),srs::spar::lat_0<>(30),srs::spar::lon_0<>(10),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102014) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43),srs::spar::lat_2<>(62),srs::spar::lat_0<>(30),srs::spar::lon_0<>(10),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102015) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_aust_sa,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-5),srs::spar::lat_2<>(-42),srs::spar::lat_0<>(-32),srs::spar::lon_0<>(-60),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102016) srs::spar::parameters<srs::spar::proj_aeqd,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aeqd(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102017) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102018) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102019) srs::spar::parameters<srs::spar::proj_aeqd,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aeqd(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102020) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102021) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102022) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(20),srs::spar::lat_2<>(-23),srs::spar::lat_0<>(0),srs::spar::lon_0<>(25),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102023) srs::spar::parameters<srs::spar::proj_eqdc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_eqdc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::lat_1<>(20),srs::spar::lat_2<>(-23),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102024) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(20),srs::spar::lat_2<>(-23),srs::spar::lat_0<>(0),srs::spar::lon_0<>(25),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102025) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(15),srs::spar::lat_2<>(65),srs::spar::lat_0<>(30),srs::spar::lon_0<>(95),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102026) srs::spar::parameters<srs::spar::proj_eqdc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_eqdc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::lat_1<>(15),srs::spar::lat_2<>(65),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102027) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(15),srs::spar::lat_2<>(65),srs::spar::lat_0<>(30),srs::spar::lon_0<>(95),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102028) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(7),srs::spar::lat_2<>(-32),srs::spar::lat_0<>(-15),srs::spar::lon_0<>(125),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102029) srs::spar::parameters<srs::spar::proj_eqdc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_eqdc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::lat_1<>(7),srs::spar::lat_2<>(-32),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102030) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(7),srs::spar::lat_2<>(-32),srs::spar::lat_0<>(-15),srs::spar::lon_0<>(125),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102031) srs::spar::parameters<srs::spar::proj_eqdc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_eqdc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::lat_1<>(43),srs::spar::lat_2<>(62),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102032) srs::spar::parameters<srs::spar::proj_eqdc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_aust_sa,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_eqdc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::lat_1<>(-5),srs::spar::lat_2<>(-42),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102033) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_aust_sa,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(-5),srs::spar::lat_2<>(-42),srs::spar::lat_0<>(-32),srs::spar::lon_0<>(-60),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102065) srs::spar::parameters<srs::spar::proj_krovak,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_krovak(),srs::spar::lat_0<>(49.5),srs::spar::lon_0<>(24.83333333333333),srs::spar::alpha<>(30.28813975277778),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102066) srs::spar::parameters<srs::spar::proj_krovak,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::pm<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_krovak(),srs::spar::lat_0<>(49.5),srs::spar::lon_0<>(42.5),srs::spar::alpha<>(30.28813975277778),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_bessel(),srs::spar::pm<>(-17.66666666666667)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102067) srs::spar::parameters<srs::spar::proj_krovak,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_krovak(),srs::spar::lat_0<>(49.5),srs::spar::lon_0<>(24.83333333333333),srs::spar::alpha<>(30.28813975277778),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102091) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(9),srs::spar::k<>(0.9996),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102092) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15),srs::spar::k<>(0.9996),srs::spar::x_0<>(2520000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102101) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(58),srs::spar::lon_0<>(6.05625),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6377492.018),srs::spar::b<>(6356173.508712696)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102102) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(58),srs::spar::lon_0<>(8.389583333333333),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6377492.018),srs::spar::b<>(6356173.508712696)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102103) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(58),srs::spar::lon_0<>(10.72291666666667),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6377492.018),srs::spar::b<>(6356173.508712696)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102104) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(58),srs::spar::lon_0<>(13.22291666666667),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6377492.018),srs::spar::b<>(6356173.508712696)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102105) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(58),srs::spar::lon_0<>(16.88958333333333),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6377492.018),srs::spar::b<>(6356173.508712696)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102106) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(58),srs::spar::lon_0<>(20.88958333333333),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6377492.018),srs::spar::b<>(6356173.508712696)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102107) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(58),srs::spar::lon_0<>(24.88958333333333),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6377492.018),srs::spar::b<>(6356173.508712696)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102108) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(58),srs::spar::lon_0<>(29.05625),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6377492.018),srs::spar::b<>(6356173.508712696)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102110) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44),srs::spar::lat_2<>(49),srs::spar::lat_0<>(46.5),srs::spar::lon_0<>(3),srs::spar::x_0<>(700000),srs::spar::y_0<>(6600000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102114) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<4>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102115) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<5>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102120) srs::spar::parameters<srs::spar::proj_omerc,srs::spar::lat_0<>,srs::spar::lonc<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_omerc(),srs::spar::lat_0<>(45.30916666666666),srs::spar::lonc<>(-86),srs::spar::alpha<>(337.255555555556),srs::spar::k<>(0.9996),srs::spar::x_0<>(2546731.495961392),srs::spar::y_0<>(-4354009.816002033),srs::spar::ellps_clrk66(),srs::spar::datum_nad27(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102121) srs::spar::parameters<srs::spar::proj_omerc,srs::spar::lat_0<>,srs::spar::lonc<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_omerc(),srs::spar::lat_0<>(45.30916666666666),srs::spar::lonc<>(-86),srs::spar::alpha<>(337.255555555556),srs::spar::k<>(0.9996),srs::spar::x_0<>(2546731.495961392),srs::spar::y_0<>(-4354009.816002033),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102122) srs::spar::parameters<srs::spar::proj_omerc,srs::spar::lat_0<>,srs::spar::lonc<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_omerc(),srs::spar::lat_0<>(45.30916666666666),srs::spar::lonc<>(-86),srs::spar::alpha<>(337.255555555556),srs::spar::k<>(0.9996),srs::spar::x_0<>(2546731.496),srs::spar::y_0<>(-4354009.816)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102123) srs::spar::parameters<srs::spar::proj_omerc,srs::spar::lat_0<>,srs::spar::lonc<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_omerc(),srs::spar::lat_0<>(45.30916666666666),srs::spar::lonc<>(-86),srs::spar::alpha<>(337.255555555556),srs::spar::k<>(0.9996),srs::spar::x_0<>(2546731.496),srs::spar::y_0<>(-4354009.816)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102132) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<32>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<32>(),srs::spar::a<>(6377492.018),srs::spar::b<>(6356173.508712696)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102133) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<33>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<33>(),srs::spar::a<>(6377492.018),srs::spar::b<>(6356173.508712696)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102134) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<34>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<34>(),srs::spar::a<>(6377492.018),srs::spar::b<>(6356173.508712696)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102135) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<35>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<35>(),srs::spar::a<>(6377492.018),srs::spar::b<>(6356173.508712696)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102140) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(22.31213333333334),srs::spar::lon_0<>(114.1785555555556),srs::spar::k<>(1),srs::spar::x_0<>(836694.05),srs::spar::y_0<>(819069.8)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102141) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<49>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102142) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<50>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102151) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<51>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102152) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<52>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102153) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<53>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102154) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<54>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102155) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<55>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102156) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<56>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102160) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(39.66666666666666),srs::spar::lon_0<>(-8.131906111111112),srs::spar::k<>(1),srs::spar::x_0<>(200180.598),srs::spar::y_0<>(299913.01)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102161) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(39.66666666666666),srs::spar::lon_0<>(-8.131906111111112),srs::spar::k<>(1),srs::spar::x_0<>(180.598),srs::spar::y_0<>(-86.98999999999999)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102162) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<26>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102163) srs::spar::parameters<srs::spar::proj_bonne,srs::spar::lon_0<>,srs::spar::lat_1<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_bonne(),srs::spar::lon_0<>(-8.131906111111112),srs::spar::lat_1<>(39.66666666666666),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102164) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(39.66666666666666),srs::spar::lon_0<>(-8.131906111111112),srs::spar::k<>(1),srs::spar::x_0<>(200000),srs::spar::y_0<>(300000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102165) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(39.66666666666666),srs::spar::lon_0<>(-8.131906111111112),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102166) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<25>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102167) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<28>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102168) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<26>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102169) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<28>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102191) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.3),srs::spar::lat_0<>(33.3),srs::spar::lon_0<>(-5.4),srs::spar::k_0<>(0.999625769),srs::spar::x_0<>(500000),srs::spar::y_0<>(300000),srs::spar::a<>(6378249.2),srs::spar::b<>(6356514.999904194)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102192) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(29.7),srs::spar::lat_0<>(29.7),srs::spar::lon_0<>(-5.4),srs::spar::k_0<>(0.9996155960000001),srs::spar::x_0<>(500000),srs::spar::y_0<>(300000),srs::spar::a<>(6378249.2),srs::spar::b<>(6356514.999904194)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102193) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(26.1),srs::spar::lat_0<>(26.1),srs::spar::lon_0<>(-5.4),srs::spar::k_0<>(0.9996),srs::spar::x_0<>(1200000),srs::spar::y_0<>(400000),srs::spar::a<>(6378249.2),srs::spar::b<>(6356514.999904194)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102229) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30.5),srs::spar::lon_0<>(-85.83333333333333),srs::spar::k<>(0.99996),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102230) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-87.5),srs::spar::k<>(0.9999333333333333),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102241) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40),srs::spar::lat_2<>(41.66666666666666),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-122),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102242) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.33333333333334),srs::spar::lat_2<>(39.83333333333334),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-122),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102243) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.06666666666667),srs::spar::lat_2<>(38.43333333333333),srs::spar::lat_0<>(36.5),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102244) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36),srs::spar::lat_2<>(37.25),srs::spar::lat_0<>(35.33333333333334),srs::spar::lon_0<>(-119),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102245) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.03333333333333),srs::spar::lat_2<>(35.46666666666667),srs::spar::lat_0<>(33.5),srs::spar::lon_0<>(-118),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102246) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(32.78333333333333),srs::spar::lat_2<>(33.88333333333333),srs::spar::lat_0<>(32.16666666666666),srs::spar::lon_0<>(-116.25),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102248) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-110.1666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(213360),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102249) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-111.9166666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(213360),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102250) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-113.75),srs::spar::k<>(0.9999333333333333),srs::spar::x_0<>(213360),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102251) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.93333333333333),srs::spar::lat_2<>(36.23333333333333),srs::spar::lat_0<>(34.33333333333334),srs::spar::lon_0<>(-92),srs::spar::x_0<>(400000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102252) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.3),srs::spar::lat_2<>(34.76666666666667),srs::spar::lat_0<>(32.66666666666666),srs::spar::lon_0<>(-92),srs::spar::x_0<>(400000),srs::spar::y_0<>(400000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102253) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.71666666666667),srs::spar::lat_2<>(40.78333333333333),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8289),srs::spar::y_0<>(304800.6096)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102254) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.45),srs::spar::lat_2<>(39.75),srs::spar::lat_0<>(37.83333333333334),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8289),srs::spar::y_0<>(304800.6096)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102255) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.23333333333333),srs::spar::lat_2<>(38.43333333333333),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8289),srs::spar::y_0<>(304800.6096)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102256) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.2),srs::spar::lat_2<>(41.86666666666667),srs::spar::lat_0<>(40.83333333333334),srs::spar::lon_0<>(-72.75),srs::spar::x_0<>(304800.6096),srs::spar::y_0<>(152400.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102257) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38),srs::spar::lon_0<>(-75.41666666666667),srs::spar::k<>(0.999995),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102258) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(24.33333333333333),srs::spar::lon_0<>(-81),srs::spar::k<>(0.9999411764705882),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102259) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(24.33333333333333),srs::spar::lon_0<>(-82),srs::spar::k<>(0.9999411764705882),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102260) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(29.58333333333333),srs::spar::lat_2<>(30.75),srs::spar::lat_0<>(29),srs::spar::lon_0<>(-84.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102261) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(18.83333333333333),srs::spar::lon_0<>(-155.5),srs::spar::k<>(0.9999666666666667),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102262) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(20.33333333333333),srs::spar::lon_0<>(-156.6666666666667),srs::spar::k<>(0.9999666666666667),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102263) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(21.16666666666667),srs::spar::lon_0<>(-158),srs::spar::k<>(0.99999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102264) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(21.83333333333333),srs::spar::lon_0<>(-159.5),srs::spar::k<>(0.99999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102265) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(21.66666666666667),srs::spar::lon_0<>(-160.1666666666667),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102266) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-82.16666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102267) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-84.16666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(700000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102268) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-112.1666666666667),srs::spar::k<>(0.9999473684210526),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102269) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-114),srs::spar::k<>(0.9999473684210526),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102270) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-115.75),srs::spar::k<>(0.9999333333333333),srs::spar::x_0<>(800000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102271) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-88.33333333333333),srs::spar::k<>(0.9999749999999999),srs::spar::x_0<>(300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102272) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-90.16666666666667),srs::spar::k<>(0.9999411764705882),srs::spar::x_0<>(700000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102273) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-85.66666666666667),srs::spar::k<>(0.9999666666666667),srs::spar::x_0<>(100000),srs::spar::y_0<>(250000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102274) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-87.08333333333333),srs::spar::k<>(0.9999666666666667),srs::spar::x_0<>(900000),srs::spar::y_0<>(250000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102277) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.71666666666667),srs::spar::lat_2<>(39.78333333333333),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-98),srs::spar::x_0<>(400000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102278) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.26666666666667),srs::spar::lat_2<>(38.56666666666667),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(400000),srs::spar::y_0<>(400000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102279) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.96666666666667),srs::spar::lat_2<>(38.96666666666667),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-84.25),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102280) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.73333333333333),srs::spar::lat_2<>(37.93333333333333),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-85.75),srs::spar::x_0<>(500000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102281) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(31.16666666666667),srs::spar::lat_2<>(32.66666666666666),srs::spar::lat_0<>(30.5),srs::spar::lon_0<>(-92.5),srs::spar::x_0<>(1000000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102282) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(29.3),srs::spar::lat_2<>(30.7),srs::spar::lat_0<>(28.5),srs::spar::lon_0<>(-91.33333333333333),srs::spar::x_0<>(1000000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102283) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(43.66666666666666),srs::spar::lon_0<>(-68.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102284) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.83333333333334),srs::spar::lon_0<>(-70.16666666666667),srs::spar::k<>(0.9999666666666667),srs::spar::x_0<>(900000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102285) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.3),srs::spar::lat_2<>(39.45),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-77),srs::spar::x_0<>(400000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102286) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.71666666666667),srs::spar::lat_2<>(42.68333333333333),srs::spar::lat_0<>(41),srs::spar::lon_0<>(-71.5),srs::spar::x_0<>(200000),srs::spar::y_0<>(750000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102287) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.28333333333333),srs::spar::lat_2<>(41.48333333333333),srs::spar::lat_0<>(41),srs::spar::lon_0<>(-70.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102288) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.48333333333333),srs::spar::lat_2<>(47.08333333333334),srs::spar::lat_0<>(44.78333333333333),srs::spar::lon_0<>(-87),srs::spar::x_0<>(8000000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102289) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.18333333333333),srs::spar::lat_2<>(45.7),srs::spar::lat_0<>(43.31666666666667),srs::spar::lon_0<>(-84.36666666666666),srs::spar::x_0<>(6000000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102290) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(42.1),srs::spar::lat_2<>(43.66666666666666),srs::spar::lat_0<>(41.5),srs::spar::lon_0<>(-84.36666666666666),srs::spar::x_0<>(4000000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102291) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.03333333333333),srs::spar::lat_2<>(48.63333333333333),srs::spar::lat_0<>(46.5),srs::spar::lon_0<>(-93.09999999999999),srs::spar::x_0<>(800000),srs::spar::y_0<>(100000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102292) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.61666666666667),srs::spar::lat_2<>(47.05),srs::spar::lat_0<>(45),srs::spar::lon_0<>(-94.25),srs::spar::x_0<>(800000),srs::spar::y_0<>(100000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102293) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43.78333333333333),srs::spar::lat_2<>(45.21666666666667),srs::spar::lat_0<>(43),srs::spar::lon_0<>(-94),srs::spar::x_0<>(800000),srs::spar::y_0<>(100000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102294) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(29.5),srs::spar::lon_0<>(-88.83333333333333),srs::spar::k<>(0.99995),srs::spar::x_0<>(300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102295) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(29.5),srs::spar::lon_0<>(-90.33333333333333),srs::spar::k<>(0.99995),srs::spar::x_0<>(700000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102296) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(35.83333333333334),srs::spar::lon_0<>(-90.5),srs::spar::k<>(0.9999333333333333),srs::spar::x_0<>(250000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102297) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(35.83333333333334),srs::spar::lon_0<>(-92.5),srs::spar::k<>(0.9999333333333333),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102298) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.16666666666666),srs::spar::lon_0<>(-94.5),srs::spar::k<>(0.9999411764705882),srs::spar::x_0<>(850000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102300) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45),srs::spar::lat_2<>(49),srs::spar::lat_0<>(44.25),srs::spar::lon_0<>(-109.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102304) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40),srs::spar::lat_2<>(43),srs::spar::lat_0<>(39.83333333333334),srs::spar::lon_0<>(-100),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102307) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-115.5833333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(8000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102308) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-116.6666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(6000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102309) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-118.5833333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(800000),srs::spar::y_0<>(4000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102310) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.5),srs::spar::lon_0<>(-71.66666666666667),srs::spar::k<>(0.9999666666666667),srs::spar::x_0<>(300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102311) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38.83333333333334),srs::spar::lon_0<>(-74.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(150000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102312) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-104.3333333333333),srs::spar::k<>(0.9999090909090909),srs::spar::x_0<>(165000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102313) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-106.25),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102314) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-107.8333333333333),srs::spar::k<>(0.9999166666666667),srs::spar::x_0<>(830000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102315) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38.83333333333334),srs::spar::lon_0<>(-74.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(150000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102316) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-76.58333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(250000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102317) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-78.58333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(350000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102318) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.66666666666666),srs::spar::lat_2<>(41.03333333333333),srs::spar::lat_0<>(40.16666666666666),srs::spar::lon_0<>(-74),srs::spar::x_0<>(300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102320) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.43333333333333),srs::spar::lat_2<>(48.73333333333333),srs::spar::lat_0<>(47),srs::spar::lon_0<>(-100.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102321) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(46.18333333333333),srs::spar::lat_2<>(47.48333333333333),srs::spar::lat_0<>(45.66666666666666),srs::spar::lon_0<>(-100.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102322) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.43333333333333),srs::spar::lat_2<>(41.7),srs::spar::lat_0<>(39.66666666666666),srs::spar::lon_0<>(-82.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102323) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.73333333333333),srs::spar::lat_2<>(40.03333333333333),srs::spar::lat_0<>(38),srs::spar::lon_0<>(-82.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102324) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(35.56666666666667),srs::spar::lat_2<>(36.76666666666667),srs::spar::lat_0<>(35),srs::spar::lon_0<>(-98),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102325) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.93333333333333),srs::spar::lat_2<>(35.23333333333333),srs::spar::lat_0<>(33.33333333333334),srs::spar::lon_0<>(-98),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102326) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.33333333333334),srs::spar::lat_2<>(46),srs::spar::lat_0<>(43.66666666666666),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(2500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102327) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(42.33333333333334),srs::spar::lat_2<>(44),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102330) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.08333333333334),srs::spar::lon_0<>(-71.5),srs::spar::k<>(0.99999375),srs::spar::x_0<>(100000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102334) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.41666666666666),srs::spar::lat_2<>(45.68333333333333),srs::spar::lat_0<>(43.83333333333334),srs::spar::lon_0<>(-100),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102335) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(42.83333333333334),srs::spar::lat_2<>(44.4),srs::spar::lat_0<>(42.33333333333334),srs::spar::lon_0<>(-100.3333333333333),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102336) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(35.25),srs::spar::lat_2<>(36.41666666666666),srs::spar::lat_0<>(34.33333333333334),srs::spar::lon_0<>(-86),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102337) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.65),srs::spar::lat_2<>(36.18333333333333),srs::spar::lat_0<>(34),srs::spar::lon_0<>(-101.5),srs::spar::x_0<>(200000),srs::spar::y_0<>(1000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102338) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(32.13333333333333),srs::spar::lat_2<>(33.96666666666667),srs::spar::lat_0<>(31.66666666666667),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(2000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102339) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.11666666666667),srs::spar::lat_2<>(31.88333333333333),srs::spar::lat_0<>(29.66666666666667),srs::spar::lon_0<>(-100.3333333333333),srs::spar::x_0<>(700000),srs::spar::y_0<>(3000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102340) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(28.38333333333333),srs::spar::lat_2<>(30.28333333333334),srs::spar::lat_0<>(27.83333333333333),srs::spar::lon_0<>(-99),srs::spar::x_0<>(600000),srs::spar::y_0<>(4000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102341) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(26.16666666666667),srs::spar::lat_2<>(27.83333333333333),srs::spar::lat_0<>(25.66666666666667),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(300000),srs::spar::y_0<>(5000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102342) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.71666666666667),srs::spar::lat_2<>(41.78333333333333),srs::spar::lat_0<>(40.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(1000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102343) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.01666666666667),srs::spar::lat_2<>(40.65),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(2000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102344) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.21666666666667),srs::spar::lat_2<>(38.35),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(3000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102345) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.5),srs::spar::lon_0<>(-72.5),srs::spar::k<>(0.9999642857142857),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102346) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.03333333333333),srs::spar::lat_2<>(39.2),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-78.5),srs::spar::x_0<>(3500000),srs::spar::y_0<>(2000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102347) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.76666666666667),srs::spar::lat_2<>(37.96666666666667),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-78.5),srs::spar::x_0<>(3500000),srs::spar::y_0<>(1000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102348) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.5),srs::spar::lat_2<>(48.73333333333333),srs::spar::lat_0<>(47),srs::spar::lon_0<>(-120.8333333333333),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102349) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.83333333333334),srs::spar::lat_2<>(47.33333333333334),srs::spar::lat_0<>(45.33333333333334),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102350) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39),srs::spar::lat_2<>(40.25),srs::spar::lat_0<>(38.5),srs::spar::lon_0<>(-79.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102351) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.48333333333333),srs::spar::lat_2<>(38.88333333333333),srs::spar::lat_0<>(37),srs::spar::lon_0<>(-81),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102352) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.56666666666667),srs::spar::lat_2<>(46.76666666666667),srs::spar::lat_0<>(45.16666666666666),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102353) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.25),srs::spar::lat_2<>(45.5),srs::spar::lat_0<>(43.83333333333334),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102354) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(42.73333333333333),srs::spar::lat_2<>(44.06666666666667),srs::spar::lat_0<>(42),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102355) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-105.1666666666667),srs::spar::k<>(0.9999375),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102356) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-107.3333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(400000),srs::spar::y_0<>(100000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102357) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-108.75),srs::spar::k<>(0.9999375),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102358) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-110.0833333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(800000),srs::spar::y_0<>(100000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102361) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(18.03333333333334),srs::spar::lat_2<>(18.43333333333333),srs::spar::lat_0<>(17.83333333333333),srs::spar::lon_0<>(-66.43333333333334),srs::spar::x_0<>(200000),srs::spar::y_0<>(200000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102491) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36),srs::spar::lat_0<>(36),srs::spar::lon_0<>(2.7),srs::spar::k_0<>(0.999625544),srs::spar::x_0<>(500000),srs::spar::y_0<>(300000),srs::spar::a<>(6378249.2),srs::spar::b<>(6356514.999904194)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102492) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.3),srs::spar::lat_0<>(33.3),srs::spar::lon_0<>(2.7),srs::spar::k_0<>(0.999625769),srs::spar::x_0<>(500000),srs::spar::y_0<>(300000),srs::spar::a<>(6378249.2),srs::spar::b<>(6356514.999904194)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102581) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(49.5),srs::spar::lat_0<>(49.5),srs::spar::lon_0<>(2.337229166666667),srs::spar::k_0<>(0.999877341),srs::spar::x_0<>(600000),srs::spar::y_0<>(1200000),srs::spar::a<>(6378249.2),srs::spar::b<>(6356514.999904194)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102582) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(46.8),srs::spar::lat_0<>(46.8),srs::spar::lon_0<>(2.337229166666667),srs::spar::k_0<>(0.99987742),srs::spar::x_0<>(600000),srs::spar::y_0<>(2200000),srs::spar::a<>(6378249.2),srs::spar::b<>(6356514.999904194)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102583) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.1),srs::spar::lat_0<>(44.1),srs::spar::lon_0<>(2.337229166666667),srs::spar::k_0<>(0.999877499),srs::spar::x_0<>(600000),srs::spar::y_0<>(3200000),srs::spar::a<>(6378249.2),srs::spar::b<>(6356514.999904194)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102584) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(42.165),srs::spar::lat_0<>(42.165),srs::spar::lon_0<>(2.337229166666667),srs::spar::k_0<>(0.99994471),srs::spar::x_0<>(234.358),srs::spar::y_0<>(4185861.369),srs::spar::a<>(6378249.2),srs::spar::b<>(6356514.999904194)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102591) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36),srs::spar::lat_0<>(36),srs::spar::lon_0<>(2.7),srs::spar::k_0<>(0.999625544),srs::spar::x_0<>(500135),srs::spar::y_0<>(300090)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102592) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.3),srs::spar::lat_0<>(33.3),srs::spar::lon_0<>(2.7),srs::spar::k_0<>(0.999625769),srs::spar::x_0<>(500135),srs::spar::y_0<>(300090)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102629) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30.5),srs::spar::lon_0<>(-85.83333333333333),srs::spar::k<>(0.99996),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102630) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-87.5),srs::spar::k<>(0.9999333333333333),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102631) srs::spar::parameters<srs::spar::proj_omerc,srs::spar::lat_0<>,srs::spar::lonc<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_omerc(),srs::spar::lat_0<>(57),srs::spar::lonc<>(-133.6666666666667),srs::spar::alpha<>(-36.86989764583333),srs::spar::k<>(0.9999),srs::spar::x_0<>(4999999.999999999),srs::spar::y_0<>(-4999999.999999999),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102632) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(54),srs::spar::lon_0<>(-142),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102633) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(54),srs::spar::lon_0<>(-146),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102634) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(54),srs::spar::lon_0<>(-150),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102635) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(54),srs::spar::lon_0<>(-154),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102636) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(54),srs::spar::lon_0<>(-158),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102637) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(54),srs::spar::lon_0<>(-162),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102638) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(54),srs::spar::lon_0<>(-166),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102639) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(54),srs::spar::lon_0<>(-170),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102640) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(51.83333333333334),srs::spar::lat_2<>(53.83333333333334),srs::spar::lat_0<>(51),srs::spar::lon_0<>(-176),srs::spar::x_0<>(1000000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102641) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40),srs::spar::lat_2<>(41.66666666666666),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-122),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000.0000000002),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102642) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.33333333333334),srs::spar::lat_2<>(39.83333333333334),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-122),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000.0000000002),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102643) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.06666666666667),srs::spar::lat_2<>(38.43333333333333),srs::spar::lat_0<>(36.5),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000.0000000002),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102644) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36),srs::spar::lat_2<>(37.25),srs::spar::lat_0<>(35.33333333333334),srs::spar::lon_0<>(-119),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000.0000000002),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102645) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.03333333333333),srs::spar::lat_2<>(35.46666666666667),srs::spar::lat_0<>(33.5),srs::spar::lon_0<>(-118),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000.0000000002),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102646) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(32.78333333333333),srs::spar::lat_2<>(33.88333333333333),srs::spar::lat_0<>(32.16666666666666),srs::spar::lon_0<>(-116.25),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000.0000000002),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102648) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-110.1666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(213360),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102649) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-111.9166666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(213360),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102650) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-113.75),srs::spar::k<>(0.9999333333333333),srs::spar::x_0<>(213360),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102651) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.93333333333333),srs::spar::lat_2<>(36.23333333333333),srs::spar::lat_0<>(34.33333333333334),srs::spar::lon_0<>(-92),srs::spar::x_0<>(399999.9999999999),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102652) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.3),srs::spar::lat_2<>(34.76666666666667),srs::spar::lat_0<>(32.66666666666666),srs::spar::lon_0<>(-92),srs::spar::x_0<>(399999.9999999999),srs::spar::y_0<>(399999.9999999999),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102653) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.71666666666667),srs::spar::lat_2<>(40.78333333333333),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8289),srs::spar::y_0<>(304800.6096),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102654) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.45),srs::spar::lat_2<>(39.75),srs::spar::lat_0<>(37.83333333333334),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8289),srs::spar::y_0<>(304800.6096),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102655) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.23333333333333),srs::spar::lat_2<>(38.43333333333333),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8289),srs::spar::y_0<>(304800.6096),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102656) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.2),srs::spar::lat_2<>(41.86666666666667),srs::spar::lat_0<>(40.83333333333334),srs::spar::lon_0<>(-72.75),srs::spar::x_0<>(304800.6096),srs::spar::y_0<>(152400.3048),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102657) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38),srs::spar::lon_0<>(-75.41666666666667),srs::spar::k<>(0.999995),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102658) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(24.33333333333333),srs::spar::lon_0<>(-81),srs::spar::k<>(0.9999411764705882),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102659) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(24.33333333333333),srs::spar::lon_0<>(-82),srs::spar::k<>(0.9999411764705882),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102660) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(29.58333333333333),srs::spar::lat_2<>(30.75),srs::spar::lat_0<>(29),srs::spar::lon_0<>(-84.5),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102661) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(18.83333333333333),srs::spar::lon_0<>(-155.5),srs::spar::k<>(0.9999666666666667),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102662) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(20.33333333333333),srs::spar::lon_0<>(-156.6666666666667),srs::spar::k<>(0.9999666666666667),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102663) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(21.16666666666667),srs::spar::lon_0<>(-158),srs::spar::k<>(0.99999),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102664) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(21.83333333333333),srs::spar::lon_0<>(-159.5),srs::spar::k<>(0.99999),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102665) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(21.66666666666667),srs::spar::lon_0<>(-160.1666666666667),srs::spar::k<>(1),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102666) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-82.16666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102667) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-84.16666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(700000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102668) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-112.1666666666667),srs::spar::k<>(0.9999473684210526),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102669) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-114),srs::spar::k<>(0.9999473684210526),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102670) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-115.75),srs::spar::k<>(0.9999333333333333),srs::spar::x_0<>(799999.9999999999),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102671) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-88.33333333333333),srs::spar::k<>(0.9999749999999999),srs::spar::x_0<>(300000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102672) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-90.16666666666667),srs::spar::k<>(0.9999411764705882),srs::spar::x_0<>(700000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102673) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-85.66666666666667),srs::spar::k<>(0.9999666666666667),srs::spar::x_0<>(100000),srs::spar::y_0<>(250000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102674) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-87.08333333333333),srs::spar::k<>(0.9999666666666667),srs::spar::x_0<>(900000.0000000001),srs::spar::y_0<>(250000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102675) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(42.06666666666667),srs::spar::lat_2<>(43.26666666666667),srs::spar::lat_0<>(41.5),srs::spar::lon_0<>(-93.5),srs::spar::x_0<>(1500000),srs::spar::y_0<>(1000000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102676) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.61666666666667),srs::spar::lat_2<>(41.78333333333333),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-93.5),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102677) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.71666666666667),srs::spar::lat_2<>(39.78333333333333),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-98),srs::spar::x_0<>(399999.9999999999),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102678) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.26666666666667),srs::spar::lat_2<>(38.56666666666667),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(399999.9999999999),srs::spar::y_0<>(399999.9999999999),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102679) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.96666666666667),srs::spar::lat_2<>(38.96666666666667),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-84.25),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102680) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.73333333333333),srs::spar::lat_2<>(37.93333333333333),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-85.75),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(500000.0000000002),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102681) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(31.16666666666667),srs::spar::lat_2<>(32.66666666666666),srs::spar::lat_0<>(30.5),srs::spar::lon_0<>(-92.5),srs::spar::x_0<>(1000000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102682) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(29.3),srs::spar::lat_2<>(30.7),srs::spar::lat_0<>(28.5),srs::spar::lon_0<>(-91.33333333333333),srs::spar::x_0<>(1000000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102683) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(43.66666666666666),srs::spar::lon_0<>(-68.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(300000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102684) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.83333333333334),srs::spar::lon_0<>(-70.16666666666667),srs::spar::k<>(0.9999666666666667),srs::spar::x_0<>(900000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102685) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.3),srs::spar::lat_2<>(39.45),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-77),srs::spar::x_0<>(399999.9999999999),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102686) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.71666666666667),srs::spar::lat_2<>(42.68333333333333),srs::spar::lat_0<>(41),srs::spar::lon_0<>(-71.5),srs::spar::x_0<>(200000),srs::spar::y_0<>(750000.0000000001),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102687) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.28333333333333),srs::spar::lat_2<>(41.48333333333333),srs::spar::lat_0<>(41),srs::spar::lon_0<>(-70.5),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102688) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.48333333333333),srs::spar::lat_2<>(47.08333333333334),srs::spar::lat_0<>(44.78333333333333),srs::spar::lon_0<>(-87),srs::spar::x_0<>(7999999.999999999),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102689) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.18333333333333),srs::spar::lat_2<>(45.7),srs::spar::lat_0<>(43.31666666666667),srs::spar::lon_0<>(-84.36666666666666),srs::spar::x_0<>(6000000.000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102690) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(42.1),srs::spar::lat_2<>(43.66666666666666),srs::spar::lat_0<>(41.5),srs::spar::lon_0<>(-84.36666666666666),srs::spar::x_0<>(4000000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102691) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.03333333333333),srs::spar::lat_2<>(48.63333333333333),srs::spar::lat_0<>(46.5),srs::spar::lon_0<>(-93.09999999999999),srs::spar::x_0<>(799999.9999999999),srs::spar::y_0<>(100000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102692) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.61666666666667),srs::spar::lat_2<>(47.05),srs::spar::lat_0<>(45),srs::spar::lon_0<>(-94.25),srs::spar::x_0<>(799999.9999999999),srs::spar::y_0<>(100000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102693) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43.78333333333333),srs::spar::lat_2<>(45.21666666666667),srs::spar::lat_0<>(43),srs::spar::lon_0<>(-94),srs::spar::x_0<>(799999.9999999999),srs::spar::y_0<>(100000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102694) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(29.5),srs::spar::lon_0<>(-88.83333333333333),srs::spar::k<>(0.99995),srs::spar::x_0<>(300000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102695) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(29.5),srs::spar::lon_0<>(-90.33333333333333),srs::spar::k<>(0.99995),srs::spar::x_0<>(700000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102696) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(35.83333333333334),srs::spar::lon_0<>(-90.5),srs::spar::k<>(0.9999333333333333),srs::spar::x_0<>(250000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102697) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(35.83333333333334),srs::spar::lon_0<>(-92.5),srs::spar::k<>(0.9999333333333333),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102698) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.16666666666666),srs::spar::lon_0<>(-94.5),srs::spar::k<>(0.9999411764705882),srs::spar::x_0<>(850000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102700) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45),srs::spar::lat_2<>(49),srs::spar::lat_0<>(44.25),srs::spar::lon_0<>(-109.5),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102704) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40),srs::spar::lat_2<>(43),srs::spar::lat_0<>(39.83333333333334),srs::spar::lon_0<>(-100),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102707) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-115.5833333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(7999999.999999999),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102708) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-116.6666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(6000000.000000001),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102709) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-118.5833333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(799999.9999999999),srs::spar::y_0<>(4000000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102710) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.5),srs::spar::lon_0<>(-71.66666666666667),srs::spar::k<>(0.9999666666666667),srs::spar::x_0<>(300000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102711) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38.83333333333334),srs::spar::lon_0<>(-74.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102712) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-104.3333333333333),srs::spar::k<>(0.9999090909090909),srs::spar::x_0<>(165000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102713) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-106.25),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102714) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-107.8333333333333),srs::spar::k<>(0.9999166666666667),srs::spar::x_0<>(829999.9999999999),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102715) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38.83333333333334),srs::spar::lon_0<>(-74.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102716) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-76.58333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(250000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102717) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-78.58333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(350000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102718) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.66666666666666),srs::spar::lat_2<>(41.03333333333333),srs::spar::lat_0<>(40.16666666666666),srs::spar::lon_0<>(-74),srs::spar::x_0<>(300000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102719) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.33333333333334),srs::spar::lat_2<>(36.16666666666666),srs::spar::lat_0<>(33.75),srs::spar::lon_0<>(-79),srs::spar::x_0<>(609601.2199999999),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102720) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.43333333333333),srs::spar::lat_2<>(48.73333333333333),srs::spar::lat_0<>(47),srs::spar::lon_0<>(-100.5),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102721) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(46.18333333333333),srs::spar::lat_2<>(47.48333333333333),srs::spar::lat_0<>(45.66666666666666),srs::spar::lon_0<>(-100.5),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102722) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.43333333333333),srs::spar::lat_2<>(41.7),srs::spar::lat_0<>(39.66666666666666),srs::spar::lon_0<>(-82.5),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102723) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.73333333333333),srs::spar::lat_2<>(40.03333333333333),srs::spar::lat_0<>(38),srs::spar::lon_0<>(-82.5),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102724) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(35.56666666666667),srs::spar::lat_2<>(36.76666666666667),srs::spar::lat_0<>(35),srs::spar::lon_0<>(-98),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102725) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.93333333333333),srs::spar::lat_2<>(35.23333333333333),srs::spar::lat_0<>(33.33333333333334),srs::spar::lon_0<>(-98),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102726) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.33333333333334),srs::spar::lat_2<>(46),srs::spar::lat_0<>(43.66666666666666),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(2500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102727) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(42.33333333333334),srs::spar::lat_2<>(44),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102728) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.88333333333333),srs::spar::lat_2<>(41.95),srs::spar::lat_0<>(40.16666666666666),srs::spar::lon_0<>(-77.75),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102729) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.93333333333333),srs::spar::lat_2<>(40.96666666666667),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-77.75),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102730) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.08333333333334),srs::spar::lon_0<>(-71.5),srs::spar::k<>(0.99999375),srs::spar::x_0<>(100000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102733) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(32.5),srs::spar::lat_2<>(34.83333333333334),srs::spar::lat_0<>(31.83333333333333),srs::spar::lon_0<>(-81),srs::spar::x_0<>(609600.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102734) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.41666666666666),srs::spar::lat_2<>(45.68333333333333),srs::spar::lat_0<>(43.83333333333334),srs::spar::lon_0<>(-100),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102735) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(42.83333333333334),srs::spar::lat_2<>(44.4),srs::spar::lat_0<>(42.33333333333334),srs::spar::lon_0<>(-100.3333333333333),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102736) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(35.25),srs::spar::lat_2<>(36.41666666666666),srs::spar::lat_0<>(34.33333333333334),srs::spar::lon_0<>(-86),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102737) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.65),srs::spar::lat_2<>(36.18333333333333),srs::spar::lat_0<>(34),srs::spar::lon_0<>(-101.5),srs::spar::x_0<>(200000),srs::spar::y_0<>(1000000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102738) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(32.13333333333333),srs::spar::lat_2<>(33.96666666666667),srs::spar::lat_0<>(31.66666666666667),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(2000000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102739) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.11666666666667),srs::spar::lat_2<>(31.88333333333333),srs::spar::lat_0<>(29.66666666666667),srs::spar::lon_0<>(-100.3333333333333),srs::spar::x_0<>(700000),srs::spar::y_0<>(3000000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102740) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(28.38333333333333),srs::spar::lat_2<>(30.28333333333334),srs::spar::lat_0<>(27.83333333333333),srs::spar::lon_0<>(-99),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(4000000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102741) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(26.16666666666667),srs::spar::lat_2<>(27.83333333333333),srs::spar::lat_0<>(25.66666666666667),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(300000),srs::spar::y_0<>(4999999.999999999),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102742) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.71666666666667),srs::spar::lat_2<>(41.78333333333333),srs::spar::lat_0<>(40.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(1000000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102743) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.01666666666667),srs::spar::lat_2<>(40.65),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(2000000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102744) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.21666666666667),srs::spar::lat_2<>(38.35),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(3000000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102745) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.5),srs::spar::lon_0<>(-72.5),srs::spar::k<>(0.9999642857142857),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102746) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.03333333333333),srs::spar::lat_2<>(39.2),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-78.5),srs::spar::x_0<>(3499999.999999999),srs::spar::y_0<>(2000000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102747) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.76666666666667),srs::spar::lat_2<>(37.96666666666667),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-78.5),srs::spar::x_0<>(3499999.999999999),srs::spar::y_0<>(1000000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102748) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.5),srs::spar::lat_2<>(48.73333333333333),srs::spar::lat_0<>(47),srs::spar::lon_0<>(-120.8333333333333),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102749) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.83333333333334),srs::spar::lat_2<>(47.33333333333334),srs::spar::lat_0<>(45.33333333333334),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(500000.0000000002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102750) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39),srs::spar::lat_2<>(40.25),srs::spar::lat_0<>(38.5),srs::spar::lon_0<>(-79.5),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102751) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.48333333333333),srs::spar::lat_2<>(38.88333333333333),srs::spar::lat_0<>(37),srs::spar::lon_0<>(-81),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102752) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.56666666666667),srs::spar::lat_2<>(46.76666666666667),srs::spar::lat_0<>(45.16666666666666),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102753) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.25),srs::spar::lat_2<>(45.5),srs::spar::lat_0<>(43.83333333333334),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102754) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(42.73333333333333),srs::spar::lat_2<>(44.06666666666667),srs::spar::lat_0<>(42),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102755) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-105.1666666666667),srs::spar::k<>(0.9999375),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102756) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-107.3333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(399999.9999999999),srs::spar::y_0<>(100000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102757) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-108.75),srs::spar::k<>(0.9999375),srs::spar::x_0<>(600000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102758) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-110.0833333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(799999.9999999999),srs::spar::y_0<>(100000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102761) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(18.03333333333334),srs::spar::lat_2<>(18.43333333333333),srs::spar::lat_0<>(17.83333333333333),srs::spar::lon_0<>(-66.43333333333334),srs::spar::x_0<>(200000),srs::spar::y_0<>(200000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 102766) srs::spar::parameters<srs::spar::proj_poly,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_poly(),srs::spar::lat_0<>(13.47246635277778),srs::spar::lon_0<>(-144.7487507055556),srs::spar::x_0<>(49999.99999999999),srs::spar::y_0<>(49999.99999999999),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 103300) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(49.8333339),srs::spar::lat_2<>(51.16666733333333),srs::spar::lat_0<>(90),srs::spar::lon_0<>(4.367486666666666),srs::spar::x_0<>(150000.01256),srs::spar::y_0<>(5400088.4378)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 104000) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 104101) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_bessel,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 104102) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_bessel,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 104103) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk80,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 104104) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 104105) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_bessel,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 104106) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 104107) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_grs80,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 104108) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_grs80,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 104261) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378249.2),srs::spar::b<>(6356514.999904194)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 104304) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378249.2),srs::spar::b<>(6356514.999904194)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(esri, 104305) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk80,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()

} // namespace detail
#endif // DOXYGEN_NO_DETAIL

}}} // namespace foundryboost::geometry::projections


#endif

