// Copyright (c) 2009-2016 Vladimir Batov.
// Use, modification and distribution are subject to the Boost Software License,
// Version 1.0. See http://www.boost.org/LICENSE_1_0.txt.

#ifndef BOOST_CONVERT_LEXICAL_CAST_HPP
#define BOOST_CONVERT_LEXICAL_CAST_HPP

#include <boost/lexical_cast.hpp>

namespace foundryboost {} namespace boost = foundryboost; namespace foundryboost { namespace cnv
{
    struct lexical_cast;
}}

/// @brief foundryboost::lexical_cast-based converter
/// @details The purpose of the converter is to
/// * Make use of the foundryboost::lexical_cast functionality and performance that many people have become
/// accustomed to and comfortable with;
/// * Demonstrate how existing independent conversion/transformation-related facilities might be
//  incorporated in to the Boost.Convert framework.
///
/// The converter can easily replace foundryboost::lexical_cast, adding flexibility and convenience.

struct foundryboost::cnv::lexical_cast
{
    template<typename TypeOut, typename TypeIn>
    void
    operator()(TypeIn const& value_in, foundryboost::optional<TypeOut>& result_out) const
    {
        try
        {
            result_out = foundryboost::lexical_cast<TypeOut>(value_in);
        }
        catch (foundryboost::bad_lexical_cast const&)
        {
        }
    }
};

#endif // BOOST_CONVERT_LEXICAL_CAST_HPP
