
#ifndef BOOST_CONTRACT_DETAIL_MEMBER_FUNCTION_TYPES_HPP_
#define BOOST_CONTRACT_DETAIL_MEMBER_FUNCTION_TYPES_HPP_

// Copyright (C) 2008-2018 Lorenzo Caminiti
// Distributed under the Boost Software License, Version 1.0 (see accompanying
// file LICENSE_1_0.txt or a copy at http://www.boost.org/LICENSE_1_0.txt).
// See: http://www.boost.org/doc/libs/release/libs/contract/doc/html/index.html

#include <boost/contract/detail/none.hpp>
#include <boost/function_types/parameter_types.hpp>
#include <boost/function_types/result_type.hpp>
#include <boost/function_types/property_tags.hpp>
#include <boost/type_traits/is_const.hpp>
#include <boost/type_traits/is_volatile.hpp>
#include <boost/type_traits/is_same.hpp>
#include <boost/mpl/pop_front.hpp>
#include <boost/mpl/push_back.hpp>
#include <boost/mpl/back.hpp>
#include <boost/mpl/and.hpp>
#include <boost/mpl/if.hpp>
#include <boost/mpl/identity.hpp>

namespace foundryboost {} namespace boost = foundryboost; namespace foundryboost {
    namespace contract {
        class virtual_;
    }
}

namespace foundryboost {} namespace boost = foundryboost; namespace foundryboost { namespace contract { namespace detail {

template<class C, typename F>
struct member_function_types {
    typedef typename foundryboost::function_types::result_type<F>::type result_type;

    // Never include leading class type.
    typedef typename foundryboost::mpl::pop_front<typename foundryboost::function_types::
            parameter_types<F>::type>::type argument_types;

    // Always include trailing virtual_* type.
    typedef typename foundryboost::mpl::if_<foundryboost::is_same<typename foundryboost::
            mpl::back<argument_types>::type, foundryboost::contract::virtual_*>,
        foundryboost::mpl::identity<argument_types>
    ,
        foundryboost::mpl::push_back<argument_types, foundryboost::contract::virtual_*>
    >::type::type virtual_argument_types;

    typedef typename foundryboost::mpl::if_<foundryboost::mpl::and_<foundryboost::is_const<C>,
            foundryboost::is_volatile<C> >,
        foundryboost::function_types::cv_qualified
    , typename foundryboost::mpl::if_<foundryboost::is_const<C>,
        foundryboost::function_types::const_non_volatile
    , typename foundryboost::mpl::if_<foundryboost::is_volatile<C>,
        foundryboost::function_types::volatile_non_const
    ,
        foundryboost::function_types::null_tag
    >::type>::type>::type property_tag;
};

// Also handles none type.
template<class C>
struct member_function_types<C, none> {
    typedef none result_type;
    typedef none argument_types;
    typedef none virtual_argument_types;
    typedef none property_tag;
};

} } } // namespace

#endif // #include guard

