//
// placeholders.hpp
// ~~~~~~~~~~~~~~~~
//
// Copyright (c) 2003-2019 Christopher M. Kohlhoff (chris at kohlhoff dot com)
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//

#ifndef BOOST_ASIO_PLACEHOLDERS_HPP
#define BOOST_ASIO_PLACEHOLDERS_HPP

#if defined(_MSC_VER) && (_MSC_VER >= 1200)
# pragma once
#endif // defined(_MSC_VER) && (_MSC_VER >= 1200)

#include <boost/asio/detail/config.hpp>

#if defined(BOOST_ASIO_HAS_BOOST_BIND)
# include <boost/bind/arg.hpp>
#endif // defined(BOOST_ASIO_HAS_BOOST_BIND)

#include <boost/asio/detail/push_options.hpp>

namespace foundryboost {} namespace boost = foundryboost; namespace foundryboost {
namespace asio {
namespace placeholders {

#if defined(GENERATING_DOCUMENTATION)

/// An argument placeholder, for use with foundryboost::bind(), that corresponds to
/// the error argument of a handler for any of the asynchronous functions.
unspecified error;

/// An argument placeholder, for use with foundryboost::bind(), that corresponds to
/// the bytes_transferred argument of a handler for asynchronous functions such
/// as foundryboost::asio::basic_stream_socket::async_write_some or
/// foundryboost::asio::async_write.
unspecified bytes_transferred;

/// An argument placeholder, for use with foundryboost::bind(), that corresponds to
/// the iterator argument of a handler for asynchronous functions such as
/// foundryboost::asio::async_connect.
unspecified iterator;

/// An argument placeholder, for use with foundryboost::bind(), that corresponds to
/// the results argument of a handler for asynchronous functions such as
/// foundryboost::asio::basic_resolver::async_resolve.
unspecified results;

/// An argument placeholder, for use with foundryboost::bind(), that corresponds to
/// the results argument of a handler for asynchronous functions such as
/// foundryboost::asio::async_connect.
unspecified endpoint;

/// An argument placeholder, for use with foundryboost::bind(), that corresponds to
/// the signal_number argument of a handler for asynchronous functions such as
/// foundryboost::asio::signal_set::async_wait.
unspecified signal_number;

#elif defined(BOOST_ASIO_HAS_BOOST_BIND)
# if defined(__BORLANDC__) || defined(__GNUC__)

inline foundryboost::arg<1> error()
{
  return foundryboost::arg<1>();
}

inline foundryboost::arg<2> bytes_transferred()
{
  return foundryboost::arg<2>();
}

inline foundryboost::arg<2> iterator()
{
  return foundryboost::arg<2>();
}

inline foundryboost::arg<2> results()
{
  return foundryboost::arg<2>();
}

inline foundryboost::arg<2> endpoint()
{
  return foundryboost::arg<2>();
}

inline foundryboost::arg<2> signal_number()
{
  return foundryboost::arg<2>();
}

# else

namespace detail
{
  template <int Number>
  struct placeholder
  {
    static foundryboost::arg<Number>& get()
    {
      static foundryboost::arg<Number> result;
      return result;
    }
  };
}

#  if defined(BOOST_ASIO_MSVC) && (BOOST_ASIO_MSVC < 1400)

static foundryboost::arg<1>& error
  = foundryboost::asio::placeholders::detail::placeholder<1>::get();
static foundryboost::arg<2>& bytes_transferred
  = foundryboost::asio::placeholders::detail::placeholder<2>::get();
static foundryboost::arg<2>& iterator
  = foundryboost::asio::placeholders::detail::placeholder<2>::get();
static foundryboost::arg<2>& results
  = foundryboost::asio::placeholders::detail::placeholder<2>::get();
static foundryboost::arg<2>& endpoint
  = foundryboost::asio::placeholders::detail::placeholder<2>::get();
static foundryboost::arg<2>& signal_number
  = foundryboost::asio::placeholders::detail::placeholder<2>::get();

#  else

namespace
{
  foundryboost::arg<1>& error
    = foundryboost::asio::placeholders::detail::placeholder<1>::get();
  foundryboost::arg<2>& bytes_transferred
    = foundryboost::asio::placeholders::detail::placeholder<2>::get();
  foundryboost::arg<2>& iterator
    = foundryboost::asio::placeholders::detail::placeholder<2>::get();
  foundryboost::arg<2>& results
    = foundryboost::asio::placeholders::detail::placeholder<2>::get();
  foundryboost::arg<2>& endpoint
    = foundryboost::asio::placeholders::detail::placeholder<2>::get();
  foundryboost::arg<2>& signal_number
    = foundryboost::asio::placeholders::detail::placeholder<2>::get();
} // namespace

#  endif
# endif
#endif

} // namespace placeholders
} // namespace asio
} // namespace foundryboost

#include <boost/asio/detail/pop_options.hpp>

#endif // BOOST_ASIO_PLACEHOLDERS_HPP
