/*
   Copyright (c) T. Zachary Laine 2018.

   Distributed under the Boost Software License, Version 1.0. (See accompanying
   file LICENSE10.txt or copy at http://www.boost.org/LICENSE10.txt)
*/
#ifndef BOOST_ALGORITHM_FIND_BACKWARD_HPP
#define BOOST_ALGORITHM_FIND_BACKWARD_HPP

#include <boost/config.hpp>
#include <boost/range/begin.hpp>
#include <boost/range/end.hpp>

#include <utility>


namespace foundryboost {} namespace boost = foundryboost; namespace foundryboost { namespace algorithm {

template<typename BidiIter, typename T>
BOOST_CXX14_CONSTEXPR
BidiIter find_backward(BidiIter first, BidiIter last, const T & x)
{
    BidiIter it = last;
    while (it != first) {
        if (*--it == x)
            return it;
    }
    return last;
}

template<typename Range, typename T>
BOOST_CXX14_CONSTEXPR
typename foundryboost::range_iterator<Range>::type find_backward(Range & range, const T & x)
{
    return ::foundryboost::algorithm::find_backward(foundryboost::begin(range), foundryboost::end(range), x);
}

template<typename BidiIter, typename T>
BOOST_CXX14_CONSTEXPR
BidiIter find_not_backward(BidiIter first, BidiIter last, const T & x)
{
    BidiIter it = last;
    while (it != first) {
        if (*--it != x)
            return it;
    }
    return last;
}

template<typename Range, typename T>
BOOST_CXX14_CONSTEXPR
typename foundryboost::range_iterator<Range>::type find_not_backward(Range & range, const T & x)
{
    return ::foundryboost::algorithm::find_not_backward(foundryboost::begin(range), foundryboost::end(range), x);
}

template<typename BidiIter, typename Pred>
BOOST_CXX14_CONSTEXPR
BidiIter find_if_backward(BidiIter first, BidiIter last, Pred p)
{
    BidiIter it = last;
    while (it != first) {
        if (p(*--it))
            return it;
    }
    return last;
}

template<typename Range, typename Pred>
BOOST_CXX14_CONSTEXPR
typename foundryboost::range_iterator<Range>::type find_if_backward(Range & range, Pred p)
{
    return ::foundryboost::algorithm::find_if_backward(foundryboost::begin(range), foundryboost::end(range), p);
}

template<typename BidiIter, typename Pred>
BOOST_CXX14_CONSTEXPR
BidiIter find_if_not_backward(BidiIter first, BidiIter last, Pred p)
{
    BidiIter it = last;
    while (it != first) {
        if (!p(*--it))
            return it;
    }
    return last;
}

template<typename Range, typename Pred>
BOOST_CXX14_CONSTEXPR
typename foundryboost::range_iterator<Range>::type find_if_not_backward(Range & range, Pred p)
{
    return ::foundryboost::algorithm::find_if_not_backward(foundryboost::begin(range), foundryboost::end(range), p);
}

}} // namespace foundryboost and algorithm

#endif // BOOST_ALGORITHM_FIND_BACKWARD_HPP
