"""
An example script that is executed when Katana starts.
"""

from Katana import Callbacks
import logging

def onStartupComplete(objectHash):
    log = logging.getLogger("Startup Example")

    import NodegraphAPI

    name = "Variable Name"
    options = ('Option 1','Option 2','Option 3')

    variablesGroup = NodegraphAPI.GetRootNode().getParameter('variables')
    variableParam = variablesGroup.createChildGroup(name)
    variableParam.createChildNumber('enable', 1)
    variableParam.createChildString('value', options[0])
    optionsParam = variableParam.createChildStringArray('options', len(options))
    for optionParam, optionValue in zip(optionsParam.getChildren(), options):
    	optionParam.setValue(optionValue, 0)

    log.info("Katana is now fully initialized and ready for use.")

log = logging.getLogger("Startup Example")
log.info("Registering onStartupComplete callback...")
Callbacks.addCallback(Callbacks.Type.onStartupComplete, onStartupComplete)
