#!/usr/bin/env bash

set -eux

# Command-line argument format
if [ "$#" -lt 7 ]; then
  echo Insufficient arguments to start agent.
  exit 1
fi

KATANA_ROOT=$1
KQ_DATA_ROOT=$2
KQ_HOST=$3
KQ_REQUEST_PORT=$4
KQ_UPDATE_PORT=$5
KQ_BROADCAST_PORT=$6
NUM_AGENTS=$7

echo Starting Katana Agent on $(hostname) to "${KQ_HOST}"

# Determine interpreter path
PYTHON_BIN="${KATANA_ROOT}/bin/python.sh"
AGENT_SCRIPT_FOLDER="${KATANA_ROOT}/plugins/Resources/Core/Plugins/kq/Agent/"
AGENT_SCRIPT="${AGENT_SCRIPT_FOLDER}/Agent.pyc"
if [ ! -f "${AGENT_SCRIPT}" ]; then
  # For debug builds
  AGENT_SCRIPT="${AGENT_SCRIPT_FOLDER}/Agent.py"
fi

# Additional python path
PYTHONPATH_INTERNAL=${PYTHONPATH:-}:"${KATANA_ROOT}/bin/python"
PYTHONPATH_INTERNAL=$PYTHONPATH_INTERNAL:"${KATANA_ROOT}/plugins/Resources/Core/Plugins"

# LD_LIBRARY_PATH for correct OpenSSL & PyZMQ
LD_LIBRARY_PATH=${LD_LIBRARY_PATH:-}:"${KATANA_ROOT}/bin:${KATANA_ROOT}/bin/OpenSSL/"

# Run the script
cd "${KATANA_ROOT}"

for (( agent = 0; agent < ${NUM_AGENTS}; agent++ )); do
  bash -c "setsid env PYTHONPATH=${PYTHONPATH_INTERNAL} \\
      KQ_DATA_ROOT=${KQ_DATA_ROOT} \\
      LD_LIBRARY_PATH=${LD_LIBRARY_PATH} \\
      ${PYTHON_BIN} ${AGENT_SCRIPT} \\
      --minimal-env True \\
      --request-port ${KQ_REQUEST_PORT} \\
      --update-port ${KQ_UPDATE_PORT} \\
      --broadcast-port ${KQ_BROADCAST_PORT} \\
      ${KQ_HOST} \\
      </dev/null \\
      >"${KQ_DATA_ROOT}/logs/remote_agent_${agent}.log" \\
      2>&1 \\
      &"

  echo "Agent ${agent} Launched"
done
