# Copyright (c) 2021 The Foundry Visionmongers Ltd. All Rights Reserved.
# Start the Katana Queue Agent

$KATANA_ROOT = $args[1]
$KQ_DATA_ROOT = $args[2]
$KQ_HOST = $args[3]
$KQ_REQUEST_PORT = $args[4]
$KQ_UPDATE_PORT = $args[5]
$KQ_BROADCAST_PORT = $args[6]
$NUM_AGENTS = $args[7]

Write-Host "Starting Katana Agent on $Env:ComputerName to $KQ_HOST"

$PYTHON_BIN = "$KATANA_ROOT\bin\python.exe"

$AGENT_SCRIPT_FOLDER = "$KATANA_ROOT\plugins\Resources\Core\Plugins\kq\Agent"
$AGENT_SCRIPT = "$AGENT_SCRIPT_FOLDER\Agent.pyc"

$PYTHONPATH = "$KATANA_ROOT\bin\python;"
$PYTHONPATH += "$KATANA_ROOT\plugins\Resources\Core\Plugins"
$PYTHONPATH += $Env:PYTHONPATH + ";"

# Build an environment for the Agent processes
$EnvCopy = [System.Environment]::GetEnvironmentVariables().GetEnumerator() | sort name
$NewEnvironment = @{}
$NewEnvironment.Add("PYTHONPATH", "$PYTHONPATH")
$NewEnvironment.Add("KQ_DATA_ROOT", $KQ_DATA_ROOT)

foreach ($v in $EnvCopy)
{
    if (!($NewEnvironment.ContainsKey($v.Name)))
    {
        $NewEnvironment.Add($v.Name, $v.Value)
    }
}

$EnvAsList = $NewEnvironment.GetEnumerator() | % { "$($_.Name)=$($_.Value)" }

$startupProperties=[wmiclass]"Win32_ProcessStartup"
$startupProperties.Properties["EnvironmentVariables"].Value = $EnvAsList

# Start the Agents
# See https://stackoverflow.com/questions/355988/how-do-i-deal-with-quote-characters-when-using-cmd-exe for cmd.exe escape rules
for ($agent = 0; $agent -lt $NUM_AGENTS; $agent++) {
    $commandString = "cmd /s /k """"$PYTHON_BIN"" ""$AGENT_SCRIPT"" "
    $commandString += "--request-port $KQ_REQUEST_PORT "
    $commandString += "--update-port $KQ_UPDATE_PORT "
    $commandString += "--broadcast-port $KQ_BROADCAST_PORT "
    $commandString += "$KQ_HOST "
    $commandString += "1> ""$KQ_DATA_ROOT\logs\remote_agent_$agent.log"" 2>&1"""

    Write-Host "Launching $commandString"
    ([wmiclass]"win32_Process").create($commandString, "$KATANA_ROOT\bin", $startupProperties)
}
