$(document).ready(function () {
    $("#smartmenu>ul.menu").on("loaded", function () {
        
        /* add classes used by smartmenus */
        $('#smartmenu>ul.menu').addClass("sm sm-mint");

        /* remove Flare's "menu" class from menu proxy */
        $('#smartmenu>ul.menu').removeClass("menu");

        // smartmenus - neglect URL params when detecting the current item
        var urlParams = location.search.replace(/^\?/, '');
        if (urlParams) {

            // 1) temporary alter menu items' links so that any URL parameters are neglected when detecting the current item
            // get just the links that do not have any params in their href
            $('#smartmenu>ul.sm a[href]:not([href*="?"])').each(function() {
                var $this = $(this),
                    href = $this.attr('href');
                $this.data('original-href', href).attr('href', href + '?' + urlParams);
            });

            // 2) after init restore original menu items' links
            $.SmartMenus.prototype.old_init = $.SmartMenus.prototype.init;
            $.SmartMenus.prototype.init = function(refresh) {
                this.old_init(refresh);

                // restore original links
                $('#smartmenu>ul.sm a[href*="?"]').each(function() {
                    var $this = $(this),
                        originalHref = $this.data('original-href');
                    if (originalHref) {
                        $this.attr('href', originalHref);
                    }
                });
            };
        }

        /* initialise smartmenus */
        $('#smartmenu>ul.sm').smartmenus({
            markCurrentItem: true,
            markCurrentTree: true,
            keepHighlighted: true,
            keepInViewport: true,
            noMouseOver: true,
            hideOnClick: false,
            collapsibleShowFunction: null
        });

        $("#smartmenu>ul.sm").smartmenus("itemActivate", $("#smartmenu").find("a.current").eq(-1));

    });
});
